/*
 * Decompiled with CFR 0.152.
 */
package io.crate.rest.action;

import io.crate.action.sql.ResultReceiver;
import io.crate.data.Row;
import io.crate.rest.action.ResultToXContentBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.elasticsearch.common.xcontent.XContentBuilder;

class RestRowCountReceiver
implements ResultReceiver<XContentBuilder> {
    private final long startTimeNs;
    private final boolean includeTypes;
    private final ResultToXContentBuilder builder;
    private final CompletableFuture<XContentBuilder> result = new CompletableFuture();
    private long rowCount;

    RestRowCountReceiver(XContentBuilder builder, long startTimeNs, boolean includeTypes) throws IOException {
        this.startTimeNs = startTimeNs;
        this.includeTypes = includeTypes;
        this.builder = ResultToXContentBuilder.builder(builder);
    }

    @Override
    public void setNextRow(Row row) {
        this.rowCount = (Long)row.get(0);
    }

    @Override
    public void batchFinished() {
        this.fail(new IllegalStateException("Incremental result streaming not supported via HTTP"));
    }

    XContentBuilder finishBuilder() throws IOException {
        this.builder.cols(Collections.emptyList());
        if (this.includeTypes) {
            this.builder.colTypes(Collections.emptyList());
        }
        this.builder.startRows().addRow(Row.EMPTY, 0).finishRows().rowCount(this.rowCount).duration(this.startTimeNs);
        return this.builder.build();
    }

    @Override
    public void allFinished(boolean interrupted) {
        try {
            this.result.complete(this.finishBuilder());
        }
        catch (IOException e) {
            this.result.completeExceptionally(e);
        }
    }

    @Override
    public void fail(@Nonnull Throwable t) {
        this.result.completeExceptionally(t);
    }

    @Override
    public CompletableFuture<XContentBuilder> completionFuture() {
        return this.result;
    }
}

