/*
 * Decompiled with CFR 0.152.
 */
package io.crate.rest.action;

import io.crate.action.sql.ResultReceiver;
import io.crate.breaker.RowAccounting;
import io.crate.data.Row;
import io.crate.expression.symbol.Symbol;
import io.crate.rest.action.ResultToXContentBuilder;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.elasticsearch.common.xcontent.XContentBuilder;

class RestResultSetReceiver
implements ResultReceiver<XContentBuilder> {
    private final List<Symbol> outputFields;
    private final ResultToXContentBuilder builder;
    private final long startTimeNs;
    private final RowAccounting<Row> rowAccounting;
    private final CompletableFuture<XContentBuilder> result = new CompletableFuture();
    private long rowCount;

    RestResultSetReceiver(XContentBuilder builder, List<Symbol> outputFields, long startTimeNs, RowAccounting<Row> rowAccounting, boolean includeTypesOnResponse) throws IOException {
        this.outputFields = outputFields;
        this.startTimeNs = startTimeNs;
        this.rowAccounting = rowAccounting;
        this.builder = ResultToXContentBuilder.builder(builder);
        this.builder.cols(outputFields);
        if (includeTypesOnResponse) {
            this.builder.colTypes(outputFields);
        }
        this.builder.startRows();
    }

    @Override
    public void setNextRow(Row row) {
        try {
            this.rowAccounting.accountForAndMaybeBreak(row);
            this.builder.addRow(row, this.outputFields.size());
            ++this.rowCount;
        }
        catch (IOException e) {
            this.fail(e);
        }
    }

    @Override
    public void batchFinished() {
        this.fail(new IllegalStateException("Incremental result streaming not supported via HTTP"));
    }

    @Override
    public void allFinished(boolean interrupted) {
        try {
            this.result.complete(this.finishBuilder());
        }
        catch (IOException e) {
            this.result.completeExceptionally(e);
        }
    }

    @Override
    public void fail(@Nonnull Throwable t) {
        this.result.completeExceptionally(t);
    }

    XContentBuilder finishBuilder() throws IOException {
        return this.builder.finishRows().rowCount(this.rowCount).duration(this.startTimeNs).build();
    }

    @Override
    public CompletableFuture<XContentBuilder> completionFuture() {
        return this.result;
    }
}

