/*
 * Decompiled with CFR 0.152.
 */
package io.crate.rest.action;

import io.crate.action.sql.BaseResultReceiver;
import io.crate.data.Row;
import io.crate.exceptions.SQLExceptions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class RestBulkRowCountReceiver
extends BaseResultReceiver {
    private final Result[] results;
    private final int resultIdx;
    private long rowCount;

    RestBulkRowCountReceiver(Result[] results, int resultIdx) {
        this.results = results;
        this.resultIdx = resultIdx;
    }

    @Override
    public void setNextRow(Row row) {
        this.rowCount = (Long)row.get(0);
    }

    @Override
    public void allFinished(boolean interrupted) {
        this.results[this.resultIdx] = new Result(null, this.rowCount);
        super.allFinished(interrupted);
    }

    @Override
    public void fail(@Nonnull Throwable t) {
        this.results[this.resultIdx] = new Result(SQLExceptions.messageOf(t), this.rowCount);
        super.fail(t);
    }

    static class Result {
        private String errorMessage;
        private long rowCount;

        Result(@Nullable String errorMessage, long rowCount) {
            this.errorMessage = errorMessage;
            this.rowCount = rowCount;
        }

        @Nullable
        String errorMessage() {
            return this.errorMessage;
        }

        long rowCount() {
            return this.rowCount;
        }
    }
}

