/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.ssl;

import io.crate.common.unit.TimeValue;
import io.crate.settings.CrateSetting;
import io.crate.types.DataTypes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public final class SslConfigSettings {
    private static final Logger LOGGER = LogManager.getLogger(SslConfigSettings.class);
    private static final String SSL_HTTP_ENABLED_SETTING_NAME = "ssl.http.enabled";
    private static final String SSL_PSQL_ENABLED_SETTING_NAME = "ssl.psql.enabled";
    static final String SSL_TRUSTSTORE_FILEPATH_SETTING_NAME = "ssl.truststore_filepath";
    static final String SSL_TRUSTSTORE_PASSWORD_SETTING_NAME = "ssl.truststore_password";
    static final String SSL_KEYSTORE_FILEPATH_SETTING_NAME = "ssl.keystore_filepath";
    static final String SSL_KEYSTORE_PASSWORD_SETTING_NAME = "ssl.keystore_password";
    static final String SSL_KEYSTORE_KEY_PASSWORD_SETTING_NAME = "ssl.keystore_key_password";
    static final String SSL_RESOURCE_POLL_INTERVAL_NAME = "ssl.resource_poll_interval";
    public static final CrateSetting<Boolean> SSL_HTTP_ENABLED = CrateSetting.of(Setting.boolSetting("ssl.http.enabled", false, Setting.Property.NodeScope), DataTypes.BOOLEAN);
    public static final CrateSetting<Boolean> SSL_PSQL_ENABLED = CrateSetting.of(Setting.boolSetting("ssl.psql.enabled", false, Setting.Property.NodeScope), DataTypes.BOOLEAN);
    public static final CrateSetting<String> SSL_TRUSTSTORE_FILEPATH = CrateSetting.of(Setting.simpleString("ssl.truststore_filepath", Setting.Property.NodeScope), DataTypes.STRING);
    public static final CrateSetting<String> SSL_TRUSTSTORE_PASSWORD = CrateSetting.of(Setting.simpleString("ssl.truststore_password", Setting.Property.NodeScope), DataTypes.STRING);
    public static final CrateSetting<String> SSL_KEYSTORE_FILEPATH = CrateSetting.of(Setting.simpleString("ssl.keystore_filepath", Setting.Property.NodeScope), DataTypes.STRING);
    public static final CrateSetting<String> SSL_KEYSTORE_PASSWORD = CrateSetting.of(Setting.simpleString("ssl.keystore_password", "", Setting.Property.NodeScope), DataTypes.STRING);
    public static final CrateSetting<String> SSL_KEYSTORE_KEY_PASSWORD = CrateSetting.of(Setting.simpleString("ssl.keystore_key_password", Setting.Property.NodeScope), DataTypes.STRING);
    public static final CrateSetting<TimeValue> SSL_RESOURCE_POLL_INTERVAL = CrateSetting.of(Setting.positiveTimeSetting("ssl.resource_poll_interval", TimeValue.timeValueMinutes(5L), Setting.Property.NodeScope), DataTypes.STRING);

    private SslConfigSettings() {
    }

    public static boolean isHttpsEnabled(Settings settings) {
        return SSL_HTTP_ENABLED.setting().get(settings);
    }

    public static boolean isPSQLSslEnabled(Settings settings) {
        return SSL_PSQL_ENABLED.setting().get(settings);
    }
}

