/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGType;
import io.crate.types.DataTypes;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

class VarCharType
extends PGType<Object> {
    static final int OID = 1043;
    private static final int ARRAY_OID = 1015;
    private static final int TYPE_LEN = -1;
    private static final int TYPE_MOD = -1;
    public static final VarCharType INSTANCE = new VarCharType(1015);
    private final int typArray;

    private VarCharType(int typArray) {
        super(1043, -1, -1, "varchar");
        this.typArray = typArray;
    }

    private VarCharType(int oid, int typArray, int maxLength, String aliasName) {
        super(oid, maxLength, -1, aliasName);
        this.typArray = typArray;
    }

    @Override
    public int typArray() {
        return this.typArray;
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.STRING.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @Nonnull Object value) {
        byte[] bytes = DataTypes.STRING.implicitCast(value).getBytes(StandardCharsets.UTF_8);
        buffer.writeInt(bytes.length);
        buffer.writeBytes(bytes);
        return 4 + bytes.length;
    }

    @Override
    public int writeAsText(ByteBuf buffer, @Nonnull Object value) {
        return this.writeAsBinary(buffer, value);
    }

    @Override
    protected byte[] encodeAsUTF8Text(@Nonnull Object value) {
        return DataTypes.STRING.implicitCast(value).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String readBinaryValue(ByteBuf buffer, int valueLength) {
        byte[] utf8 = new byte[valueLength];
        buffer.readBytes(utf8);
        return new String(utf8, StandardCharsets.UTF_8);
    }

    @Override
    String decodeUTF8Text(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    static class TextType {
        static final int OID = 25;
        static final int TEXT_ARRAY_OID = 1009;
        static final VarCharType INSTANCE = new VarCharType(25, 1009, -1, "text");

        TextType() {
        }
    }

    static class NameType {
        static final int OID = 19;
        private static final int ARRAY_OID = -1;
        private static final int TYPE_LEN = 64;
        static final VarCharType INSTANCE = new VarCharType(19, -1, 64, "name");

        NameType() {
        }
    }
}

