/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.BaseTimestampType;
import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.crate.types.DataTypes;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

final class TimestampZType
extends BaseTimestampType {
    public static final PGType INSTANCE = new TimestampZType();
    private static final int OID = 1184;
    private static final String NAME = "timestamptz";
    private static final DateTimeFormatter ISO_FORMATTER = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm:ss.SSS+00").withZoneUTC().withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter ISO_FORMATTER_WITH_ERA = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm:ss.SSS+00 G").withZoneUTC().withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter[] PARSERS_WITHOUT_ERA = TimestampZType.generateParseFormatters(false);
    private static final DateTimeFormatter[] PARSERS_WITH_ERA = TimestampZType.generateParseFormatters(true);

    private static DateTimeFormatter[] generateParseFormatters(boolean withEra) {
        DateTimeFormatter[] formatters = new DateTimeFormatter[10];
        String prefix = "YYYY-MM-dd HH:mm:ss";
        String suffix = "ZZ";
        if (withEra) {
            suffix = "ZZ G";
        }
        formatters[0] = DateTimeFormat.forPattern((String)(prefix + suffix)).withLocale(Locale.ENGLISH);
        for (int i = 1; i < 10; ++i) {
            StringBuilder pattern = new StringBuilder(prefix);
            pattern.append('.');
            for (int j = 1; j <= i; ++j) {
                pattern.append('S');
            }
            pattern.append(suffix);
            formatters[i] = DateTimeFormat.forPattern((String)pattern.toString()).withLocale(Locale.ENGLISH);
        }
        return formatters;
    }

    private TimestampZType() {
        super(1184, 8, -1, NAME);
    }

    @Override
    public int typArray() {
        return PGArray.TIMESTAMPZ_ARRAY.oid();
    }

    byte[] encodeAsUTF8Text(@Nonnull Object value) {
        long msecs = (Long)value;
        if (msecs >= -62135596800000L) {
            return ISO_FORMATTER.print(msecs).getBytes(StandardCharsets.UTF_8);
        }
        return ISO_FORMATTER_WITH_ERA.print(msecs).getBytes(StandardCharsets.UTF_8);
    }

    Object decodeUTF8Text(byte[] bytes) {
        String s = new String(bytes, StandardCharsets.UTF_8);
        try {
            return DataTypes.TIMESTAMPZ.explicitCast(s);
        }
        catch (Exception e) {
            boolean withEra;
            int fractionDigits;
            int endOfSeconds;
            int idx = endOfSeconds = s.indexOf(".");
            if (endOfSeconds > 0) {
                ++idx;
                while (s.charAt(idx) != '+' && s.charAt(idx) != '-') {
                    ++idx;
                }
            }
            int n = fractionDigits = (fractionDigits = idx - endOfSeconds - 1) < 0 ? 0 : fractionDigits;
            if (fractionDigits > 9) {
                throw new IllegalArgumentException("Cannot parse more than 9 digits for fraction of a second");
            }
            boolean bl = withEra = s.endsWith("BC") || s.endsWith("AD");
            if (withEra) {
                return PARSERS_WITH_ERA[fractionDigits].parseMillis(s);
            }
            return PARSERS_WITHOUT_ERA[fractionDigits].parseMillis(s);
        }
    }
}

