/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.BaseTimestampType;
import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Locale;
import javax.annotation.Nonnull;

final class TimestampType
extends BaseTimestampType {
    public static final PGType INSTANCE = new TimestampType();
    private static final int OID = 1114;
    private static final String NAME = "timestamp without time zone";
    private static final DateTimeFormatter PARSER_WITH_OPTIONAL_ERA = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendPattern("[VV][x][xx][xxx]").optionalStart().appendLiteral(' ').appendPattern("G").toFormatter(Locale.ENGLISH).withResolverStyle(ResolverStyle.STRICT);
    private static final DateTimeFormatter ISO_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd HH:mm:ss.SSS+00").toFormatter(Locale.ENGLISH).withResolverStyle(ResolverStyle.STRICT);
    private static final DateTimeFormatter ISO_FORMATTER_WITH_ERA = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_FORMATTER).appendLiteral(' ').appendPattern("G").toFormatter(Locale.ENGLISH).withResolverStyle(ResolverStyle.STRICT);

    private TimestampType() {
        super(1114, 8, -1, NAME);
    }

    @Override
    public int typArray() {
        return PGArray.TIMESTAMP_ARRAY.oid();
    }

    byte[] encodeAsUTF8Text(@Nonnull Object value) {
        long millis = (Long)value;
        LocalDateTime ts = LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
        if (millis >= -62135596800000L) {
            return ts.format(ISO_FORMATTER).getBytes(StandardCharsets.UTF_8);
        }
        return ts.format(ISO_FORMATTER_WITH_ERA).getBytes(StandardCharsets.UTF_8);
    }

    Object decodeUTF8Text(byte[] bytes) {
        String s = new String(bytes, StandardCharsets.UTF_8);
        LocalDateTime dt = LocalDateTime.parse(s, PARSER_WITH_OPTIONAL_ERA);
        return dt.toInstant(ZoneOffset.UTC).toEpochMilli();
    }
}

