/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.crate.types.TimeTZ;
import io.crate.types.TimeTZParser;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nonnull;

final class TimeTZType
extends PGType<TimeTZ> {
    public static final PGType<TimeTZ> INSTANCE = new TimeTZType();
    private static final int OID = 1266;
    private static final String OID_TYPE_NAME = "timetz";
    private static final int TYPE_MOD = -1;

    TimeTZType() {
        super(1266, 12, -1, OID_TYPE_NAME);
    }

    @Override
    public int typArray() {
        return PGArray.TIMETZ_ARRAY.oid();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.DATETIME.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @Nonnull TimeTZ value) {
        buffer.writeInt(12);
        buffer.writeLong(value.getMicrosFromMidnight());
        buffer.writeInt(value.getSecondsFromUTC());
        return 16;
    }

    @Override
    public TimeTZ readBinaryValue(ByteBuf buffer, int valueLength) {
        assert (valueLength == 12) : String.format(Locale.ENGLISH, "valueLength must be %d because timetz is a 12 byte structure. Actual length: %d", 12, valueLength);
        return new TimeTZ(buffer.readLong(), buffer.readInt());
    }

    @Override
    byte[] encodeAsUTF8Text(@Nonnull TimeTZ time) {
        return TimeTZParser.formatTime(time).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    TimeTZ decodeUTF8Text(byte[] bytes) {
        return TimeTZParser.parse(new String(bytes, StandardCharsets.UTF_8));
    }
}

