/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

class RealType
extends PGType<Float> {
    public static final RealType INSTANCE = new RealType();
    static final int OID = 700;
    private static final int TYPE_LEN = 4;
    private static final int TYPE_MOD = -1;

    private RealType() {
        super(700, 4, -1, "float4");
    }

    @Override
    public int typArray() {
        return PGArray.FLOAT4_ARRAY.oid();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.NUMERIC.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @Nonnull Float value) {
        buffer.writeInt(4);
        buffer.writeFloat(value.floatValue());
        return 8;
    }

    @Override
    protected byte[] encodeAsUTF8Text(@Nonnull Float value) {
        return Float.toString(value.floatValue()).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Float readBinaryValue(ByteBuf buffer, int valueLength) {
        assert (valueLength == 4) : "length should be 4 because float is int32. Actual length: " + valueLength;
        return Float.valueOf(buffer.readFloat());
    }

    @Override
    Float decodeUTF8Text(byte[] bytes) {
        return Float.valueOf(Float.parseFloat(new String(bytes, StandardCharsets.UTF_8)));
    }
}

