/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGType;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.impl.PointImpl;

public final class PointType
extends PGType<Point> {
    public static final PointType INSTANCE = new PointType();
    static final int OID = 600;
    private static final int TYPE_LEN = 16;
    private static final int TYPE_MOD = -1;

    PointType() {
        super(600, 16, -1, "point");
    }

    @Override
    public int typArray() {
        return 1017;
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.GEOMETRIC.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @Nonnull Point point) {
        buffer.writeInt(16);
        buffer.writeDouble(point.getX());
        buffer.writeDouble(point.getY());
        return 20;
    }

    @Override
    public Point readBinaryValue(ByteBuf buffer, int valueLength) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        return new PointImpl(x, y, (SpatialContext)JtsSpatialContext.GEO);
    }

    @Override
    byte[] encodeAsUTF8Text(@Nonnull Point point) {
        return ("(" + String.valueOf(point.getX()) + "," + point.getY() + ")").getBytes(StandardCharsets.UTF_8);
    }

    @Override
    Point decodeUTF8Text(byte[] bytes) {
        String value = new String(bytes, StandardCharsets.UTF_8);
        StringTokenizer tokenizer = new StringTokenizer(value, ",()");
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("Cannot parse input as point: " + value + " expected a point in format: (x, y)");
        }
        double x = Double.parseDouble(tokenizer.nextToken());
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("Cannot parse input as point: " + value + " expected a point in format: (x, y)");
        }
        double y = Double.parseDouble(tokenizer.nextToken());
        return new PointImpl(x, y, (SpatialContext)JtsSpatialContext.GEO);
    }
}

