/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.types.Regproc;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PGType<T> {
    static final int INT32_BYTE_SIZE = 4;
    private static final Logger LOGGER = LogManager.getLogger(PGType.class);
    private final int oid;
    private final int typeLen;
    private final int typeMod;
    private final String typName;

    PGType(int oid, int typeLen, int typeMod, @Nonnull String typName) {
        this.oid = oid;
        this.typeLen = typeLen;
        this.typeMod = typeMod;
        this.typName = typName;
    }

    public int oid() {
        return this.oid;
    }

    public short typeLen() {
        return (short)this.typeLen;
    }

    public abstract int typArray();

    public int typeMod() {
        return this.typeMod;
    }

    public String typName() {
        return this.typName;
    }

    public Regproc typInput() {
        if (this.typArray() == 0) {
            return Regproc.of("array_in");
        }
        return Regproc.of(this.typName() + "_in");
    }

    public Regproc typOutput() {
        if (this.typArray() == 0) {
            return Regproc.of("array_out");
        }
        return Regproc.of(this.typName() + "_out");
    }

    public Regproc typReceive() {
        if (this.typArray() == 0) {
            return Regproc.of("array_recv");
        }
        return Regproc.of(this.typName() + "recv");
    }

    public int typElem() {
        return 0;
    }

    public String typDelim() {
        return ",";
    }

    public abstract String typeCategory();

    public abstract String type();

    public int writeAsText(ByteBuf buffer, @Nonnull T value) {
        byte[] bytes = this.encodeAsUTF8Text(value);
        buffer.writeInt(bytes.length);
        buffer.writeBytes(bytes);
        return 4 + bytes.length;
    }

    public T readTextValue(ByteBuf buffer, int valueLength) {
        byte[] bytes = new byte[valueLength];
        buffer.readBytes(bytes);
        try {
            return this.decodeUTF8Text(bytes);
        }
        catch (Throwable t) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("decodeUTF8Text failed. input={} type={}", (Object)new String(bytes, StandardCharsets.UTF_8), (Object)this.typName);
            }
            throw t;
        }
    }

    public abstract int writeAsBinary(ByteBuf var1, @Nonnull T var2);

    public abstract T readBinaryValue(ByteBuf var1, int var2);

    abstract byte[] encodeAsUTF8Text(@Nonnull T var1);

    abstract T decodeUTF8Text(byte[] var1);

    static enum TypeCategory {
        ARRAY("A"),
        BOOLEAN("B"),
        COMPOSITE("C"),
        DATETIME("D"),
        GEOMETRIC("G"),
        NETWORK("I"),
        NUMERIC("N"),
        PSEUDO("P"),
        RANGE("R"),
        STRING("S"),
        TIMESPAN("T"),
        USER_DEFINED_TYPES("U"),
        BIT_STRING("V"),
        UNKNOWN("X");

        private final String code;

        private TypeCategory(String code) {
            this.code = code;
        }

        public String code() {
            return this.code;
        }
    }

    static enum Type {
        BASE("b"),
        COMPOSITE("c"),
        ENUM("e"),
        DOMAIN("d"),
        PSEUDO("p"),
        RANGE("r");

        private final String code;

        private Type(String code) {
            this.code = code;
        }

        public String code() {
            return this.code;
        }
    }
}

