/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import com.google.common.primitives.Bytes;
import io.crate.protocols.postgres.parser.PgArrayParser;
import io.crate.protocols.postgres.types.AnyType;
import io.crate.protocols.postgres.types.BigIntType;
import io.crate.protocols.postgres.types.BooleanType;
import io.crate.protocols.postgres.types.CharType;
import io.crate.protocols.postgres.types.DoubleType;
import io.crate.protocols.postgres.types.IntegerType;
import io.crate.protocols.postgres.types.IntervalType;
import io.crate.protocols.postgres.types.JsonType;
import io.crate.protocols.postgres.types.NumericType;
import io.crate.protocols.postgres.types.OidType;
import io.crate.protocols.postgres.types.PGType;
import io.crate.protocols.postgres.types.PointType;
import io.crate.protocols.postgres.types.RealType;
import io.crate.protocols.postgres.types.RecordType;
import io.crate.protocols.postgres.types.RegprocType;
import io.crate.protocols.postgres.types.SmallIntType;
import io.crate.protocols.postgres.types.TimeTZType;
import io.crate.protocols.postgres.types.TimestampType;
import io.crate.protocols.postgres.types.TimestampZType;
import io.crate.protocols.postgres.types.VarCharType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class PGArray
extends PGType<List<Object>> {
    private final PGType<?> innerType;
    static final PGArray CHAR_ARRAY = new PGArray(1002, CharType.INSTANCE);
    static final PGArray INT2_ARRAY = new PGArray(1005, SmallIntType.INSTANCE);
    static final PGArray INT4_ARRAY = new PGArray(1007, IntegerType.INSTANCE);
    static final PGArray OID_ARRAY = new PGArray(1028, OidType.INSTANCE);
    static final PGArray INT8_ARRAY = new PGArray(1016, BigIntType.INSTANCE);
    static final PGArray FLOAT4_ARRAY = new PGArray(1021, RealType.INSTANCE);
    static final PGArray FLOAT8_ARRAY = new PGArray(1022, DoubleType.INSTANCE);
    static final PGArray NUMERIC_ARRAY = new PGArray(1231, NumericType.INSTANCE);
    static final PGArray BOOL_ARRAY = new PGArray(1000, BooleanType.INSTANCE);
    static final PGArray TIMESTAMPZ_ARRAY = new PGArray(1185, TimestampZType.INSTANCE);
    static final PGArray TIMESTAMP_ARRAY = new PGArray(1115, TimestampType.INSTANCE);
    static final PGArray TIMETZ_ARRAY = new PGArray(1270, TimeTZType.INSTANCE);
    static final PGArray VARCHAR_ARRAY = new PGArray(1015, VarCharType.INSTANCE);
    static final PGArray TEXT_ARRAY = new PGArray(1009, VarCharType.TextType.INSTANCE);
    static final PGArray JSON_ARRAY = new PGArray(199, JsonType.INSTANCE);
    static final PGArray POINT_ARRAY = new PGArray(1017, PointType.INSTANCE);
    static final PGArray INTERVAL_ARRAY = new PGArray(1187, IntervalType.INSTANCE);
    static final PGArray EMPTY_RECORD_ARRAY = new PGArray(2287, RecordType.EMPTY_RECORD);
    static final PGArray REGPROC_ARRAY = new PGArray(1008, RegprocType.INSTANCE);
    public static final PGArray ANY_ARRAY = new PGArray(2277, AnyType.INSTANCE.typName() + "array", (PGType)AnyType.INSTANCE){

        @Override
        public String typeCategory() {
            return PGType.TypeCategory.PSEUDO.code();
        }
    };
    private static final byte[] NULL_BYTES = new byte[]{78, 85, 76, 76};

    PGArray(int oid, String name, PGType<?> innerType) {
        super(oid, -1, -1, name);
        this.innerType = innerType;
    }

    PGArray(int oid, PGType<?> innerType) {
        this(oid, "_" + innerType.typName(), innerType);
    }

    @Override
    public int typArray() {
        return 0;
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.ARRAY.code();
    }

    @Override
    public String type() {
        return this.innerType.type();
    }

    @Override
    public int typElem() {
        return this.innerType.oid();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @Nonnull List<Object> value) {
        int dimensions = this.getDimensions(value);
        ArrayList<Integer> dimensionsList = new ArrayList<Integer>();
        this.buildDimensions(value, dimensionsList, dimensions, 1);
        int bytesWritten = 12;
        int lenIndex = buffer.writerIndex();
        buffer.writeInt(0);
        buffer.writeInt(dimensions);
        buffer.writeInt(1);
        buffer.writeInt(this.typElem());
        for (Integer dim : dimensionsList) {
            buffer.writeInt(dim.intValue());
            buffer.writeInt(dim.intValue());
            bytesWritten += 8;
        }
        int len = bytesWritten + this.writeArrayAsBinary(buffer, value, dimensionsList, 1);
        buffer.setInt(lenIndex, len);
        return 4 + len;
    }

    private int getDimensions(@Nonnull Object value) {
        int dimensions = 0;
        Object array = value;
        do {
            ++dimensions;
            List arr = (List)array;
            if (arr.isEmpty()) break;
            array = null;
            for (Object o : arr) {
                if (o == null) continue;
                array = o;
            }
        } while (array instanceof List);
        return dimensions;
    }

    @Override
    public List<Object> readBinaryValue(ByteBuf buffer, int valueLength) {
        int dimensions = buffer.readInt();
        buffer.readInt();
        buffer.readInt();
        if (dimensions == 0) {
            return List.of();
        }
        int[] dims = new int[dimensions];
        for (int d = 0; d < dimensions; ++d) {
            dims[d] = buffer.readInt();
            buffer.readInt();
        }
        ArrayList<Object> values = new ArrayList<Object>(dims[0]);
        this.readArrayAsBinary(buffer, values, dims, 0);
        return values;
    }

    @Override
    byte[] encodeAsUTF8Text(@Nonnull List<Object> array) {
        boolean isJson = 114 == this.innerType.oid();
        ArrayList<Byte> encodedValues = new ArrayList<Byte>();
        encodedValues.add((byte)123);
        for (int i = 0; i < array.size(); ++i) {
            byte[] bytes;
            Object o = array.get(i);
            if (o instanceof List) {
                for (byte b : bytes = this.encodeAsUTF8Text((List)o)) {
                    encodedValues.add(b);
                }
                if (i != 0) continue;
                encodedValues.add((byte)44);
                continue;
            }
            if (i > 0) {
                encodedValues.add((byte)44);
            }
            if (o == null) {
                for (byte aByte : bytes = NULL_BYTES) {
                    encodedValues.add(aByte);
                }
                continue;
            }
            bytes = this.innerType.encodeAsUTF8Text(o);
            encodedValues.add((byte)34);
            if (isJson) {
                for (byte aByte : bytes) {
                    char ch = (char)aByte;
                    if (ch == '\"' || ch == '\\') {
                        encodedValues.add((byte)92);
                    }
                    encodedValues.add(aByte);
                }
            } else {
                for (byte aByte : bytes) {
                    encodedValues.add(aByte);
                }
            }
            encodedValues.add((byte)34);
        }
        encodedValues.add((byte)125);
        return Bytes.toArray(encodedValues);
    }

    @Override
    List<Object> decodeUTF8Text(byte[] bytes) {
        return (List)PgArrayParser.parse(bytes, this.innerType::decodeUTF8Text);
    }

    private int buildDimensions(List<Object> values, List<Integer> dimensionsList, int maxDimensions, int currentDimension) {
        if (values == null) {
            return 1;
        }
        if (currentDimension < maxDimensions) {
            int max = 0;
            for (Object o : values) {
                max = Math.max(max, this.buildDimensions((List)o, dimensionsList, maxDimensions, currentDimension + 1));
            }
            if (currentDimension == maxDimensions - 1) {
                dimensionsList.add(max);
            } else {
                Integer current = dimensionsList.get(0);
                dimensionsList.set(0, Math.max(current, max));
            }
        }
        if (currentDimension == 1) {
            dimensionsList.add(0, values.size());
        }
        return values.size();
    }

    private int writeArrayAsBinary(ByteBuf buffer, List<Object> array, List<Integer> dimensionsList, int currentDimension) {
        int bytesWritten = 0;
        if (array == null) {
            for (int i = 0; i < dimensionsList.get(currentDimension - 1); ++i) {
                buffer.writeInt(-1);
                bytesWritten += 4;
            }
            return bytesWritten;
        }
        if (currentDimension == dimensionsList.size()) {
            int i = 0;
            for (Object o : array) {
                if (o == null) {
                    buffer.writeInt(-1);
                    bytesWritten += 4;
                } else {
                    bytesWritten += this.innerType.writeAsBinary(buffer, o);
                }
                ++i;
            }
            while (i < dimensionsList.get(currentDimension - 1)) {
                buffer.writeInt(-1);
                bytesWritten += 4;
                ++i;
            }
        } else {
            for (Object o : array) {
                bytesWritten += this.writeArrayAsBinary(buffer, (List)o, dimensionsList, currentDimension + 1);
            }
        }
        return bytesWritten;
    }

    private void readArrayAsBinary(ByteBuf buffer, List<Object> array, int[] dims, int thisDimension) {
        if (thisDimension == dims.length - 1) {
            for (int i = 0; i < dims[thisDimension]; ++i) {
                int len = buffer.readInt();
                if (len == -1) {
                    array.add(null);
                    continue;
                }
                array.add(this.innerType.readBinaryValue(buffer, len));
            }
        } else {
            for (int i = 0; i < dims[thisDimension]; ++i) {
                ArrayList<Object> list = new ArrayList<Object>(dims[thisDimension + 1]);
                array.add(list);
                this.readArrayAsBinary(buffer, list, dims, thisDimension + 1);
            }
        }
    }
}

