/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public class OidType
extends PGType<Integer> {
    public static final OidType INSTANCE = new OidType();
    static final int OID = 26;
    private static final int TYPE_LEN = 4;
    private static final int TYPE_MOD = -1;

    OidType() {
        super(26, 4, -1, "oid");
    }

    @Override
    public int typArray() {
        return PGArray.OID_ARRAY.oid();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.NUMERIC.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, Integer value) {
        buffer.writeInt(4);
        buffer.writeInt(value.intValue());
        return 8;
    }

    @Override
    public Integer readBinaryValue(ByteBuf buffer, int valueLength) {
        assert (valueLength == 4) : "length should be 4 because oid is int32. Actual length: " + valueLength;
        return buffer.readInt();
    }

    @Override
    byte[] encodeAsUTF8Text(Integer value) {
        return Integer.toString(value).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    Integer decodeUTF8Text(byte[] bytes) {
        return Integer.parseInt(new String(bytes, StandardCharsets.UTF_8));
    }
}

