/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

class NumericType
extends PGType<BigDecimal> {
    static final int OID = 1700;
    private static final int TYPE_LEN = -1;
    private static final int TYPE_MOD = -1;
    private static final short DEC_DIGITS = 4;
    private static final short NUMERIC_POS = 0;
    private static final short NUMERIC_NEG = 16384;
    private static final short NUMERIC_NAN = -16384;
    public static final NumericType INSTANCE = new NumericType();

    private NumericType() {
        super(1700, -1, -1, "numeric");
    }

    @Override
    public int typArray() {
        return PGArray.NUMERIC_ARRAY.oid();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.NUMERIC.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @Nonnull BigDecimal value) {
        int start;
        char[] digits = value.unscaledValue().toString().toCharArray();
        int end = digits.length;
        for (start = 0; start < end && (digits[start] == '0' || digits[start] == '-'); ++start) {
        }
        int dWeight = end - start - value.scale() - 1;
        while (start < end && digits[end - 1] == '0') {
            --end;
        }
        int len = end - start;
        short weight = 0;
        int offset = 0;
        int nDigits = 0;
        if (len != 0) {
            weight = dWeight >= 0 ? (short)((dWeight + 1 + 4 - 1) / 4 - 1) : (short)(-((-dWeight - 1) / 4 + 1));
            offset = (weight + 1) * 4 - (dWeight + 1);
            nDigits = (short)((len + offset + 4 - 1) / 4);
        }
        int typeLen = 2 * (4 + nDigits);
        buffer.writeInt(typeLen);
        buffer.writeShort(nDigits);
        buffer.writeShort((int)weight);
        switch (value.signum()) {
            case -1: {
                buffer.writeShort(16384);
                break;
            }
            case 0: {
                buffer.writeShort(-16384);
                break;
            }
            case 1: {
                buffer.writeShort(0);
                break;
            }
            default: {
                buffer.writeShort(0);
            }
        }
        buffer.writeShort(value.scale());
        int digitIdx = -offset + start;
        while (true) {
            int n = nDigits;
            nDigits = (short)(nDigits - 1);
            if (n <= 0) break;
            int ndigit = 0;
            int nextDigitIdx = digitIdx + 4;
            while (digitIdx < nextDigitIdx) {
                ndigit = (short)(ndigit * 10);
                if (digitIdx >= start && digitIdx < end) {
                    ndigit = (short)(ndigit + (digits[digitIdx] - 48));
                }
                ++digitIdx;
            }
            buffer.writeShort(ndigit);
        }
        return 4 + typeLen;
    }

    @Override
    public BigDecimal readBinaryValue(ByteBuf buffer, int valueLength) {
        int nDigits = buffer.readShort();
        short weight = buffer.readShort();
        short sign = buffer.readShort();
        short scale = buffer.readShort();
        if (sign == -16384) {
            throw new IllegalArgumentException("Infinite or NaN values are not supported");
        }
        boolean has_dp = scale > 0;
        int sizeOfBytes = nDigits * 4 + (has_dp ? 1 : 0);
        char[] decDigits = new char[sizeOfBytes];
        int decDigitsIdx = 0;
        for (int i = 0; i < nDigits; ++i) {
            int decDigit = buffer.readShort();
            if (decDigit > 0) {
                for (int j = 1000; j > 0 && decDigitsIdx < sizeOfBytes; j /= 10) {
                    int d1 = decDigit / j;
                    decDigit -= d1 * j;
                    decDigits[decDigitsIdx++] = (char)(d1 + 48);
                }
            }
            if (!has_dp || i != weight) continue;
            decDigits[decDigitsIdx++] = 46;
        }
        BigDecimal bd = new BigDecimal(decDigits).setScale((int)scale, MathContext.UNLIMITED.getRoundingMode());
        return sign == 16384 ? bd.negate() : bd;
    }

    @Override
    protected byte[] encodeAsUTF8Text(@Nonnull BigDecimal value) {
        return value.toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    BigDecimal decodeUTF8Text(byte[] bytes) {
        return new BigDecimal(new String(bytes, StandardCharsets.UTF_8));
    }
}

