/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;

class JsonType
extends PGType<Object> {
    public static final JsonType INSTANCE = new JsonType();
    static final int OID = 114;
    private static final int TYPE_LEN = -1;
    private static final int TYPE_MOD = -1;

    private JsonType() {
        super(114, -1, -1, "json");
    }

    @Override
    public int typArray() {
        return PGArray.JSON_ARRAY.oid();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.USER_DEFINED_TYPES.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @Nonnull Object value) {
        byte[] bytes = this.encodeAsUTF8Text(value);
        buffer.writeInt(bytes.length);
        buffer.writeBytes(bytes);
        return 4 + bytes.length;
    }

    @Override
    protected byte[] encodeAsUTF8Text(@Nonnull Object value) {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder();
            if (value instanceof List) {
                List values = (List)value;
                builder.startArray();
                for (Object o : values) {
                    builder.value(o);
                }
                builder.endArray();
            } else {
                builder.map((Map)value);
            }
            builder.close();
            return BytesReference.toBytes(BytesReference.bytes(builder));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object readBinaryValue(ByteBuf buffer, int valueLength) {
        byte[] bytes = new byte[valueLength];
        buffer.readBytes(bytes);
        return this.decodeUTF8Text(bytes);
    }

    @Override
    Object decodeUTF8Text(byte[] bytes) {
        try {
            XContentParser parser = JsonXContent.JSON_XCONTENT.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, bytes);
            if (bytes.length > 1 && bytes[0] == 91) {
                parser.nextToken();
                return parser.list();
            }
            return parser.map();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

