/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

class DoubleType
extends PGType<Double> {
    public static final DoubleType INSTANCE = new DoubleType();
    static final int OID = 701;
    private static final int TYPE_LEN = 8;
    private static final int TYPE_MOD = -1;

    private DoubleType() {
        super(701, 8, -1, "float8");
    }

    @Override
    public int typArray() {
        return PGArray.FLOAT8_ARRAY.oid();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.NUMERIC.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @Nonnull Double value) {
        buffer.writeInt(8);
        buffer.writeDouble(value.doubleValue());
        return 12;
    }

    @Override
    protected byte[] encodeAsUTF8Text(@Nonnull Double value) {
        return Double.toString(value).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Double readBinaryValue(ByteBuf buffer, int valueLength) {
        assert (valueLength == 8) : "length should be 8 because double is int64. Actual length: " + valueLength;
        return buffer.readDouble();
    }

    @Override
    Double decodeUTF8Text(byte[] bytes) {
        return Double.parseDouble(new String(bytes, StandardCharsets.UTF_8));
    }
}

