/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

class BigIntType
extends PGType<Long> {
    public static final BigIntType INSTANCE = new BigIntType();
    static final int OID = 20;
    private static final int TYPE_LEN = 8;
    private static final int TYPE_MOD = -1;

    private BigIntType() {
        super(20, 8, -1, "int8");
    }

    @Override
    public int typArray() {
        return PGArray.INT8_ARRAY.oid();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @Nonnull Long value) {
        buffer.writeInt(8);
        buffer.writeLong(value.longValue());
        return 12;
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.NUMERIC.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    protected byte[] encodeAsUTF8Text(@Nonnull Long value) {
        return Long.toString(value).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Long readBinaryValue(ByteBuf buffer, int valueLength) {
        assert (valueLength == 8) : "length should be 8 because long is int64. Actual length: " + valueLength;
        return buffer.readLong();
    }

    @Override
    Long decodeUTF8Text(byte[] bytes) {
        return Long.parseLong(new String(bytes, StandardCharsets.UTF_8));
    }
}

