/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGType;
import io.crate.types.Regproc;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

public class AnyType
extends PGType<Integer> {
    public static final AnyType INSTANCE = new AnyType();
    private static final int TYPE_LEN = 4;
    static final int OID = 2276;

    private AnyType() {
        super(2276, 4, -1, "any");
    }

    @Override
    public int typArray() {
        return 0;
    }

    @Override
    public String type() {
        return PGType.Type.PSEUDO.code();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.PSEUDO.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @Nonnull Integer value) {
        buffer.writeInt(4);
        buffer.writeInt(value.intValue());
        return 8;
    }

    @Override
    public Regproc typReceive() {
        return Regproc.of(0, "-");
    }

    @Override
    protected byte[] encodeAsUTF8Text(@Nonnull Integer value) {
        return Integer.toString(value).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Integer readBinaryValue(ByteBuf buffer, int valueLength) {
        return buffer.readInt();
    }

    @Override
    Integer decodeUTF8Text(byte[] bytes) {
        return Integer.parseInt(new String(bytes, StandardCharsets.UTF_8));
    }
}

