/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.parser;

import com.carrotsearch.hppc.ByteArrayList;
import io.crate.protocols.postgres.antlr.v4.PgArrayBaseVisitor;
import io.crate.protocols.postgres.antlr.v4.PgArrayParser;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Function;
import org.antlr.v4.runtime.tree.ParseTree;

class PgArrayASTVisitor
extends PgArrayBaseVisitor<Object> {
    private final Function<byte[], Object> convert;

    PgArrayASTVisitor(Function<byte[], Object> convert) {
        this.convert = convert;
    }

    @Override
    public Object visitArray(PgArrayParser.ArrayContext ctx) {
        ArrayList<Object> array = new ArrayList<Object>();
        for (PgArrayParser.ItemContext value : ctx.item()) {
            array.add(this.visit((ParseTree)value));
        }
        return array;
    }

    @Override
    public Object visitValue(PgArrayParser.ValueContext ctx) {
        PgArrayParser.StringContext stringContext = ctx.string();
        if (stringContext == null) {
            return this.convert.apply(PgArrayASTVisitor.processArrayItem(ctx.getText().getBytes(StandardCharsets.UTF_8)));
        }
        Object value = this.visit((ParseTree)stringContext);
        if (value == null) {
            return null;
        }
        return this.convert.apply(PgArrayASTVisitor.processArrayItem(((String)value).getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public Object visitQuotedString(PgArrayParser.QuotedStringContext ctx) {
        String text = ctx.getText();
        return text.substring(1, text.length() - 1);
    }

    @Override
    public Object visitUnquotedString(PgArrayParser.UnquotedStringContext ctx) {
        String text = ctx.getText();
        return "null".equalsIgnoreCase(text) ? null : text;
    }

    @Override
    public Object visitNull(PgArrayParser.NullContext ctx) {
        return null;
    }

    private static byte[] processArrayItem(byte[] bytes) {
        ByteArrayList itemBytes = new ByteArrayList();
        int start = 0;
        int end = bytes.length - 1;
        for (int i = start; i <= end; ++i) {
            if (i < end && (char)bytes[i] == '\\' && ((char)bytes[i + 1] == '\\' || (char)bytes[i + 1] == '\"')) {
                ++i;
            }
            itemBytes.add(bytes[i]);
        }
        return itemBytes.toArray();
    }
}

