/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.protocols.ssl.SslContextProvider;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import javax.annotation.Nullable;

public final class SslReqHandler {
    static final int SSL_REQUEST_BYTE_LENGTH = 8;
    static final int SSL_REQUEST_CODE = 80877103;
    private final SslContextProvider sslContextProvider;

    SslReqHandler(@Nullable SslContextProvider sslContextProvider) {
        this.sslContextProvider = sslContextProvider;
    }

    public State process(ByteBuf buffer, ChannelPipeline pipeline) {
        if (buffer.readableBytes() < 8) {
            return State.WAITING_FOR_INPUT;
        }
        buffer.markReaderIndex();
        if (buffer.readInt() == 8 && buffer.readInt() == 80877103) {
            SslContext sslContext = this.sslContextProvider != null ? this.sslContextProvider.getSslContext() : null;
            if (sslContext != null) {
                SslReqHandler.writeByteAndFlushMessage(pipeline.channel(), 83);
                SslHandler sslHandler = sslContext.newHandler(pipeline.channel().alloc());
                pipeline.addFirst(new ChannelHandler[]{sslHandler});
            } else {
                SslReqHandler.writeByteAndFlushMessage(pipeline.channel(), 78);
            }
            buffer.markReaderIndex();
        } else {
            buffer.resetReaderIndex();
        }
        return State.DONE;
    }

    private static void writeByteAndFlushMessage(Channel channel, int byteToWrite) {
        ByteBuf channelBuffer = channel.alloc().buffer(1);
        channelBuffer.writeByte(byteToWrite);
        channel.writeAndFlush((Object)channelBuffer);
    }

    static enum State {
        WAITING_FOR_INPUT,
        DONE;

    }
}

