/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.action.sql.BaseResultReceiver;
import io.crate.auth.user.AccessControl;
import io.crate.data.Row;
import io.crate.protocols.postgres.Messages;
import io.netty.channel.Channel;
import javax.annotation.Nonnull;

class RowCountReceiver
extends BaseResultReceiver {
    private final Channel channel;
    private final String query;
    private final AccessControl accessControl;
    private long rowCount;

    RowCountReceiver(String query, Channel channel, AccessControl accessControl) {
        this.query = query;
        this.channel = channel;
        this.accessControl = accessControl;
    }

    @Override
    public void setNextRow(Row row) {
        this.rowCount = (Long)row.get(0);
        if (this.rowCount < 0L) {
            --this.rowCount;
        }
    }

    @Override
    public void allFinished(boolean interrupted) {
        Messages.sendCommandComplete(this.channel, this.query, this.rowCount).addListener(f -> super.allFinished(interrupted));
    }

    @Override
    public void fail(@Nonnull Throwable throwable) {
        Messages.sendErrorResponse(this.channel, this.accessControl, throwable).addListener(f -> super.fail(throwable));
    }
}

