/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.action.sql.ResultReceiver;
import io.crate.common.unit.TimeValue;
import io.crate.data.Row;
import io.crate.exceptions.SQLExceptions;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.ConnectTransportException;

public class RetryOnFailureResultReceiver
implements ResultReceiver {
    private static final Logger LOGGER = LogManager.getLogger(RetryOnFailureResultReceiver.class);
    private final ClusterService clusterService;
    private final ClusterState initialState;
    private final Predicate<String> hasIndex;
    private final ResultReceiver delegate;
    private final UUID jobId;
    private final BiConsumer<UUID, ResultReceiver> retryAction;
    private int attempt = 1;

    public RetryOnFailureResultReceiver(ClusterService clusterService, ClusterState initialState, Predicate<String> hasIndex, ResultReceiver delegate, UUID jobId, BiConsumer<UUID, ResultReceiver> retryAction) {
        this.clusterService = clusterService;
        this.initialState = initialState;
        this.hasIndex = hasIndex;
        this.delegate = delegate;
        this.jobId = jobId;
        this.retryAction = retryAction;
    }

    @Override
    public void setNextRow(Row row) {
        this.delegate.setNextRow(row);
    }

    @Override
    public void batchFinished() {
        this.delegate.batchFinished();
    }

    @Override
    public void allFinished(boolean interrupted) {
        this.delegate.allFinished(interrupted);
    }

    @Override
    public void fail(@Nonnull Throwable wrappedError) {
        final Throwable error = SQLExceptions.unwrap(wrappedError);
        if (this.attempt <= 3 && (SQLExceptions.isShardFailure(error) || error instanceof ConnectTransportException || this.indexWasTemporaryUnavailable(error))) {
            if (this.clusterService.state().blocks().hasGlobalBlockWithStatus(RestStatus.SERVICE_UNAVAILABLE)) {
                this.delegate.fail(error);
            } else {
                ClusterStateObserver clusterStateObserver = new ClusterStateObserver(this.initialState, this.clusterService, null, LOGGER);
                clusterStateObserver.waitForNextChange(new ClusterStateObserver.Listener(){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        ++RetryOnFailureResultReceiver.this.attempt;
                        RetryOnFailureResultReceiver.this.retry();
                    }

                    @Override
                    public void onClusterServiceClose() {
                        RetryOnFailureResultReceiver.this.delegate.fail(error);
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        RetryOnFailureResultReceiver.this.delegate.fail(error);
                    }
                });
            }
        } else {
            this.delegate.fail(error);
        }
    }

    private boolean indexWasTemporaryUnavailable(Throwable t) {
        return t instanceof IndexNotFoundException && this.hasIndex.test(((IndexNotFoundException)t).getIndex().getName());
    }

    private void retry() {
        UUID newJobId = UUID.randomUUID();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Retrying statement due to a shard failure, attempt={}, jobId={}->{}", (Object)this.attempt, (Object)this.jobId, (Object)newJobId);
        }
        this.retryAction.accept(newJobId, this);
    }

    @Override
    public CompletableFuture<?> completionFuture() {
        return this.delegate.completionFuture();
    }

    public String toString() {
        return "RetryOnFailureResultReceiver{delegate=" + this.delegate + ", jobId=" + this.jobId + ", attempt=" + this.attempt + "}";
    }
}

