/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.action.sql.BaseResultReceiver;
import io.crate.auth.user.AccessControl;
import io.crate.data.Row;
import io.crate.protocols.postgres.FormatCodes;
import io.crate.protocols.postgres.Messages;
import io.crate.protocols.postgres.TransactionState;
import io.crate.protocols.postgres.types.PGType;
import io.netty.channel.Channel;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ResultSetReceiver
extends BaseResultReceiver {
    private final String query;
    private final Channel channel;
    private final List<PGType<?>> columnTypes;
    private final TransactionState transactionState;
    private final AccessControl accessControl;
    @Nullable
    private final FormatCodes.FormatCode[] formatCodes;
    private long rowCount = 0L;

    ResultSetReceiver(String query, Channel channel, TransactionState transactionState, AccessControl accessControl, List<PGType<?>> columnTypes, @Nullable FormatCodes.FormatCode[] formatCodes) {
        this.query = query;
        this.channel = channel;
        this.transactionState = transactionState;
        this.accessControl = accessControl;
        this.columnTypes = columnTypes;
        this.formatCodes = formatCodes;
    }

    @Override
    public void setNextRow(Row row) {
        ++this.rowCount;
        Messages.sendDataRow(this.channel, row, this.columnTypes, this.formatCodes);
        if (this.rowCount % 1000L == 0L) {
            this.channel.flush();
        }
    }

    @Override
    public void batchFinished() {
        Messages.sendPortalSuspended(this.channel);
        Messages.sendReadyForQuery(this.channel, this.transactionState);
    }

    @Override
    public void allFinished(boolean interrupted) {
        if (interrupted) {
            super.allFinished(true);
        } else {
            Messages.sendCommandComplete(this.channel, this.query, this.rowCount).addListener(f -> super.allFinished(false));
        }
    }

    @Override
    public void fail(@Nonnull Throwable throwable) {
        Messages.sendErrorResponse(this.channel, this.accessControl, throwable).addListener(f -> super.fail(throwable));
    }
}

