/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import java.util.ArrayList;
import java.util.List;

class QueryStringSplitter {
    QueryStringSplitter() {
    }

    public static List<String> splitQuery(String query) {
        ArrayList<String> queries = new ArrayList<String>(2);
        CommentType commentType = CommentType.NO;
        QuoteType quoteType = QuoteType.NONE;
        boolean restoreSingleQuoteIfEscaped = false;
        char[] chars = query.toCharArray();
        boolean isCurrentlyEmpty = true;
        int offset = 0;
        int lastChar = 32;
        for (int i = 0; i < chars.length; ++i) {
            int aChar = chars[i];
            if (isCurrentlyEmpty && !Character.isWhitespace((char)aChar)) {
                isCurrentlyEmpty = false;
            }
            switch (aChar) {
                case 39: {
                    if (commentType != CommentType.NO || quoteType == QuoteType.DOUBLE) break;
                    if (lastChar == 39) {
                        quoteType = restoreSingleQuoteIfEscaped ? QuoteType.SINGLE : QuoteType.NONE;
                        restoreSingleQuoteIfEscaped = false;
                        break;
                    }
                    restoreSingleQuoteIfEscaped = quoteType == QuoteType.SINGLE;
                    quoteType = quoteType == QuoteType.SINGLE ? QuoteType.NONE : QuoteType.SINGLE;
                    break;
                }
                case 34: {
                    if (commentType != CommentType.NO || quoteType == QuoteType.SINGLE) break;
                    quoteType = quoteType == QuoteType.DOUBLE ? QuoteType.NONE : QuoteType.DOUBLE;
                    break;
                }
                case 45: {
                    if (commentType != CommentType.NO || quoteType != QuoteType.NONE || lastChar != 45) break;
                    commentType = CommentType.LINE;
                    break;
                }
                case 42: {
                    if (commentType != CommentType.NO || quoteType != QuoteType.NONE || lastChar != 47) break;
                    commentType = CommentType.MULTI_LINE;
                    break;
                }
                case 47: {
                    if (commentType != CommentType.MULTI_LINE || lastChar != 42) break;
                    commentType = CommentType.NO;
                    offset = i + 1;
                    break;
                }
                case 10: {
                    if (commentType != CommentType.LINE) break;
                    commentType = CommentType.NO;
                    offset = i + 1;
                    break;
                }
                case 59: {
                    if (commentType != CommentType.NO || quoteType != QuoteType.NONE) break;
                    queries.add(new String(chars, offset, i - offset + 1));
                    offset = i + 1;
                    isCurrentlyEmpty = true;
                    break;
                }
            }
            lastChar = aChar;
        }
        if (!isCurrentlyEmpty && offset < chars.length && commentType == CommentType.NO) {
            queries.add(new String(chars, offset, chars.length - offset));
        }
        if (queries.isEmpty()) {
            queries.add("");
        }
        return queries;
    }

    static enum CommentType {
        NO,
        LINE,
        MULTI_LINE;

    }

    static enum QuoteType {
        NONE,
        SINGLE,
        DOUBLE;

    }
}

