/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.action.sql.PreparedStmt;
import io.crate.action.sql.RowConsumerToResultReceiver;
import io.crate.analyze.AnalyzedStatement;
import io.crate.protocols.postgres.FormatCodes;
import java.util.List;
import javax.annotation.Nullable;

public final class Portal {
    private String portalName;
    private final PreparedStmt preparedStmt;
    private final List<Object> params;
    private final AnalyzedStatement analyzedStatement;
    @Nullable
    private final FormatCodes.FormatCode[] resultFormatCodes;
    private RowConsumerToResultReceiver consumer;

    public Portal(String portalName, PreparedStmt preparedStmt, List<Object> params, AnalyzedStatement analyzedStatement, @Nullable FormatCodes.FormatCode[] resultFormatCodes) {
        this.portalName = portalName;
        this.preparedStmt = preparedStmt;
        this.params = params;
        this.analyzedStatement = analyzedStatement;
        this.resultFormatCodes = resultFormatCodes;
    }

    public String name() {
        return this.portalName;
    }

    public PreparedStmt preparedStmt() {
        return this.preparedStmt;
    }

    public List<Object> params() {
        return this.params;
    }

    @Nullable
    public FormatCodes.FormatCode[] resultFormatCodes() {
        return this.resultFormatCodes;
    }

    public AnalyzedStatement analyzedStatement() {
        return this.analyzedStatement;
    }

    public void setActiveConsumer(RowConsumerToResultReceiver consumer) {
        this.consumer = consumer;
    }

    @Nullable
    public RowConsumerToResultReceiver activeConsumer() {
        return this.consumer;
    }

    public void closeActiveConsumer() {
        if (this.consumer != null) {
            this.consumer.closeAndFinishIfSuspended();
        }
    }

    public String toString() {
        return "Portal{portalName=" + this.portalName + ", preparedStmt=" + this.preparedStmt.rawStatement() + "}";
    }
}

