/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.auth.user.AccessControl;
import io.crate.data.Row;
import io.crate.exceptions.SQLExceptions;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.pgcatalog.OidHash;
import io.crate.protocols.postgres.FormatCodes;
import io.crate.protocols.postgres.PGError;
import io.crate.protocols.postgres.PGErrorStatus;
import io.crate.protocols.postgres.TransactionState;
import io.crate.protocols.postgres.types.PGType;
import io.crate.protocols.postgres.types.PGTypes;
import io.crate.types.DataType;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Messages {
    private static final Logger LOGGER = LogManager.getLogger(Messages.class);
    private static final byte[] METHOD_NAME_CLIENT_AUTH = "ClientAuthentication".getBytes(StandardCharsets.UTF_8);

    public static ChannelFuture sendAuthenticationOK(Channel channel) {
        ByteBuf buffer = channel.alloc().buffer(9);
        buffer.writeByte(82);
        buffer.writeInt(8);
        buffer.writeInt(0);
        ChannelFuture channelFuture = channel.writeAndFlush((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> LOGGER.trace("sentAuthenticationOK")));
        }
        return channelFuture;
    }

    static ChannelFuture sendCommandComplete(Channel channel, String query, long rowCount) {
        Object commandTag = "BEGIN".equals(query = query.trim().split(" ", 2)[0].toUpperCase(Locale.ENGLISH)) ? "BEGIN" : ("INSERT".equals(query) ? "INSERT 0 " + rowCount : query + " " + rowCount);
        byte[] commandTagBytes = ((String)commandTag).getBytes(StandardCharsets.UTF_8);
        int length = 4 + commandTagBytes.length + 1;
        ByteBuf buffer = channel.alloc().buffer(length + 1);
        buffer.writeByte(67);
        buffer.writeInt(length);
        Messages.writeCString(buffer, commandTagBytes);
        ChannelFuture channelFuture = channel.writeAndFlush((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> LOGGER.trace("sentCommandComplete")));
        }
        return channelFuture;
    }

    static void sendReadyForQuery(Channel channel, TransactionState transactionState) {
        ByteBuf buffer = channel.alloc().buffer(6);
        buffer.writeByte(90);
        buffer.writeInt(5);
        buffer.writeByte(transactionState.code());
        ChannelFuture channelFuture = channel.writeAndFlush((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> LOGGER.trace("sentReadyForQuery")));
        }
    }

    static void sendParameterStatus(Channel channel, String name, String value) {
        byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
        byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
        int length = 4 + nameBytes.length + 1 + valueBytes.length + 1;
        ByteBuf buffer = channel.alloc().buffer(length + 1);
        buffer.writeByte(83);
        buffer.writeInt(length);
        Messages.writeCString(buffer, nameBytes);
        Messages.writeCString(buffer, valueBytes);
        ChannelFuture channelFuture = channel.write((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> LOGGER.trace("sentParameterStatus {}={}", (Object)name, (Object)value)));
        }
    }

    static void sendAuthenticationError(Channel channel, String message) {
        LOGGER.warn(message);
        byte[] msg = message.getBytes(StandardCharsets.UTF_8);
        byte[] errorCode = PGErrorStatus.INVALID_AUTHORIZATION_SPECIFICATION.code().getBytes(StandardCharsets.UTF_8);
        Messages.sendErrorResponse(channel, message, msg, PGError.SEVERITY_FATAL, null, null, METHOD_NAME_CLIENT_AUTH, errorCode);
    }

    static ChannelFuture sendErrorResponse(Channel channel, AccessControl accessControl, Throwable throwable) {
        PGError error = PGError.fromThrowable(SQLExceptions.prepareForClientTransmission(accessControl, throwable));
        byte[] msg = error.message().getBytes(StandardCharsets.UTF_8);
        byte[] errorCode = error.status().code().getBytes(StandardCharsets.UTF_8);
        byte[] lineNumber = null;
        byte[] fileName = null;
        byte[] methodName = null;
        StackTraceElement[] stackTrace = error.throwable().getStackTrace();
        if (stackTrace != null && stackTrace.length > 0) {
            StackTraceElement stackTraceElement = stackTrace[0];
            lineNumber = String.valueOf(stackTraceElement.getLineNumber()).getBytes(StandardCharsets.UTF_8);
            if (stackTraceElement.getFileName() != null) {
                fileName = stackTraceElement.getFileName().getBytes(StandardCharsets.UTF_8);
            }
            if (stackTraceElement.getMethodName() != null) {
                methodName = stackTraceElement.getMethodName().getBytes(StandardCharsets.UTF_8);
            }
        }
        return Messages.sendErrorResponse(channel, error.message(), msg, PGError.SEVERITY_ERROR, lineNumber, fileName, methodName, errorCode);
    }

    private static ChannelFuture sendErrorResponse(Channel channel, String message, byte[] msg, byte[] severity, byte[] lineNumber, byte[] fileName, byte[] methodName, byte[] errorCode) {
        int length = 5 + (severity.length + 1) + 1 + (msg.length + 1) + 1 + (errorCode.length + 1) + (fileName != null ? 1 + (fileName.length + 1) : 0) + (lineNumber != null ? 1 + (lineNumber.length + 1) : 0) + (methodName != null ? 1 + (methodName.length + 1) : 0) + 1;
        ByteBuf buffer = channel.alloc().buffer(length + 1);
        buffer.writeByte(69);
        buffer.writeInt(length);
        buffer.writeByte(83);
        Messages.writeCString(buffer, severity);
        buffer.writeByte(77);
        Messages.writeCString(buffer, msg);
        buffer.writeByte(67);
        Messages.writeCString(buffer, errorCode);
        if (fileName != null) {
            buffer.writeByte(70);
            Messages.writeCString(buffer, fileName);
        }
        if (lineNumber != null) {
            buffer.writeByte(76);
            Messages.writeCString(buffer, lineNumber);
        }
        if (methodName != null) {
            buffer.writeByte(82);
            Messages.writeCString(buffer, methodName);
        }
        buffer.writeByte(0);
        ChannelFuture channelFuture = channel.writeAndFlush((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> LOGGER.trace("sentErrorResponse msg={}", (Object)message)));
        }
        return channelFuture;
    }

    static void sendDataRow(Channel channel, Row row, List<PGType<?>> columnTypes, @Nullable FormatCodes.FormatCode[] formatCodes) {
        int length = 6;
        assert (columnTypes.size() == row.numColumns()) : "Number of columns in the row must match number of columnTypes. Row: " + row + " types: " + columnTypes;
        ByteBuf buffer = channel.alloc().buffer();
        buffer.writeByte(68);
        buffer.writeInt(0);
        buffer.writeShort(row.numColumns());
        block6: for (int i = 0; i < row.numColumns(); ++i) {
            Object value;
            PGType<?> pgType = columnTypes.get(i);
            try {
                value = row.get(i);
            }
            catch (Exception e) {
                buffer.release();
                throw e;
            }
            if (value == null) {
                buffer.writeInt(-1);
                length += 4;
                continue;
            }
            FormatCodes.FormatCode formatCode = FormatCodes.getFormatCode(formatCodes, i);
            switch (formatCode) {
                case TEXT: {
                    length += pgType.writeAsText(buffer, value);
                    continue block6;
                }
                case BINARY: {
                    length += pgType.writeAsBinary(buffer, value);
                    continue block6;
                }
                default: {
                    buffer.release();
                    throw new AssertionError((Object)("Unrecognized formatCode: " + formatCode));
                }
            }
        }
        buffer.setInt(1, length);
        channel.write((Object)buffer);
    }

    static void writeCString(ByteBuf buffer, byte[] valBytes) {
        buffer.writeBytes(valBytes);
        buffer.writeByte(0);
    }

    static void sendParameterDescription(Channel channel, DataType[] parameters) {
        int messageByteSize = 6 + parameters.length * 4;
        ByteBuf buffer = channel.alloc().buffer(messageByteSize);
        buffer.writeByte(116);
        buffer.writeInt(messageByteSize);
        if (parameters.length > Short.MAX_VALUE) {
            buffer.release();
            throw new IllegalArgumentException("Too many parameters. Max supported: 32767");
        }
        buffer.writeShort(parameters.length);
        for (DataType dataType : parameters) {
            int pgTypeId = PGTypes.get(dataType).oid();
            buffer.writeInt(pgTypeId);
        }
        channel.write((Object)buffer);
    }

    static void sendRowDescription(Channel channel, Collection<Symbol> columns, @Nullable FormatCodes.FormatCode[] formatCodes, @Nullable RelationInfo relation) {
        int length = 6;
        int columnSize = 18;
        ByteBuf buffer = channel.alloc().buffer(length + columns.size() * (10 + columnSize));
        buffer.writeByte(84);
        buffer.writeInt(0);
        buffer.writeShort(columns.size());
        int tableOid = relation == null ? 0 : OidHash.relationOid(relation);
        int idx = 0;
        for (Symbol column : columns) {
            byte[] nameBytes = Symbols.pathFromSymbol(column).sqlFqn().getBytes(StandardCharsets.UTF_8);
            length += nameBytes.length + 1;
            length += columnSize;
            Messages.writeCString(buffer, nameBytes);
            buffer.writeInt(tableOid);
            if (column instanceof Reference) {
                Integer position = ((Reference)column).position();
                buffer.writeShort(position == null ? 0 : position);
            } else {
                buffer.writeShort(0);
            }
            PGType pgType = PGTypes.get(column.valueType());
            buffer.writeInt(pgType.oid());
            buffer.writeShort((int)pgType.typeLen());
            buffer.writeInt(pgType.typeMod());
            buffer.writeShort(FormatCodes.getFormatCode(formatCodes, idx).ordinal());
            ++idx;
        }
        buffer.setInt(1, length);
        ChannelFuture channelFuture = channel.write((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> LOGGER.trace("sentRowDescription")));
        }
    }

    static void sendParseComplete(Channel channel) {
        Messages.sendShortMsg(channel, '1', "sentParseComplete");
    }

    static void sendBindComplete(Channel channel) {
        Messages.sendShortMsg(channel, '2', "sentBindComplete");
    }

    static void sendEmptyQueryResponse(Channel channel) {
        Messages.sendShortMsg(channel, 'I', "sentEmptyQueryResponse");
    }

    static void sendNoData(Channel channel) {
        Messages.sendShortMsg(channel, 'n', "sentNoData");
    }

    private static void sendShortMsg(Channel channel, char msgType, String traceLogMsg) {
        ByteBuf buffer = channel.alloc().buffer(5);
        buffer.writeByte((int)msgType);
        buffer.writeInt(4);
        ChannelFuture channelFuture = channel.write((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> LOGGER.trace(traceLogMsg)));
        }
    }

    static void sendPortalSuspended(Channel channel) {
        Messages.sendShortMsg(channel, 's', "sentPortalSuspended");
    }

    static void sendCloseComplete(Channel channel) {
        Messages.sendShortMsg(channel, '3', "sentCloseComplete");
    }

    static void sendAuthenticationCleartextPassword(Channel channel) {
        ByteBuf buffer = channel.alloc().buffer(9);
        buffer.writeByte(82);
        buffer.writeInt(8);
        buffer.writeInt(3);
        ChannelFuture channelFuture = channel.writeAndFlush((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> LOGGER.trace("sentAuthenticationCleartextPassword")));
        }
    }
}

