/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;

public class FormatCodes {
    private static final FormatCode[] EMPTY_FORMAT_CODES = new FormatCode[0];

    static FormatCode[] fromBuffer(ByteBuf buffer) {
        int numFormatCodes = buffer.readShort();
        if (numFormatCodes == 0) {
            return EMPTY_FORMAT_CODES;
        }
        FormatCode[] formatCodes = new FormatCode[numFormatCodes];
        for (int i = 0; i < numFormatCodes; ++i) {
            formatCodes[i] = FormatCode.values()[buffer.readShort()];
        }
        return formatCodes;
    }

    static FormatCode getFormatCode(@Nullable FormatCode[] formatCodes, int idx) {
        if (formatCodes == null || formatCodes.length == 0) {
            return FormatCode.TEXT;
        }
        return formatCodes.length == 1 ? formatCodes[0] : formatCodes[idx];
    }

    public static enum FormatCode {
        TEXT,
        BINARY;

    }
}

