/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;

public class DelayableWriteChannel
implements Channel {
    private final Channel delegate;
    private volatile DelayedWrites delay;

    public DelayableWriteChannel(Channel channel) {
        this.delegate = channel;
    }

    public <T> Attribute<T> attr(AttributeKey<T> key) {
        return this.delegate.attr(key);
    }

    public <T> boolean hasAttr(AttributeKey<T> key) {
        return this.delegate.hasAttr(key);
    }

    public ChannelFuture bind(SocketAddress localAddress) {
        return this.delegate.bind(localAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.delegate.connect(remoteAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.delegate.connect(remoteAddress, localAddress);
    }

    public ChannelFuture disconnect() {
        return this.delegate.disconnect();
    }

    public ChannelFuture close() {
        return this.delegate.close();
    }

    public ChannelFuture deregister() {
        return this.delegate.deregister();
    }

    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        return this.delegate.bind(localAddress, promise);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.delegate.connect(remoteAddress, promise);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        return this.delegate.connect(remoteAddress, localAddress, promise);
    }

    public ChannelFuture disconnect(ChannelPromise promise) {
        return this.delegate.disconnect(promise);
    }

    public ChannelFuture close(ChannelPromise promise) {
        return this.delegate.close(promise);
    }

    public ChannelFuture deregister(ChannelPromise promise) {
        return this.delegate.deregister(promise);
    }

    public ChannelFuture write(Object msg) {
        if (this.delay != null) {
            ChannelPromise newPromise = this.newPromise();
            this.delay.add(() -> this.delegate.write(msg, newPromise));
            return newPromise;
        }
        return this.delegate.write(msg);
    }

    public ChannelFuture write(Object msg, ChannelPromise promise) {
        if (this.delay != null) {
            this.delay.add(() -> this.delegate.write(msg, promise));
            return promise;
        }
        return this.delegate.write(msg, promise);
    }

    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        if (this.delay != null) {
            this.delay.add(() -> this.delegate.writeAndFlush(msg, promise));
            return promise;
        }
        return this.delegate.writeAndFlush(msg, promise);
    }

    public ChannelFuture writeAndFlush(Object msg) {
        if (this.delay != null) {
            ChannelPromise promise = this.newPromise();
            this.delay.add(() -> this.delegate.writeAndFlush(msg, promise));
            return promise;
        }
        return this.delegate.writeAndFlush(msg);
    }

    public ChannelPromise newPromise() {
        return this.delegate.newPromise();
    }

    public ChannelProgressivePromise newProgressivePromise() {
        return this.delegate.newProgressivePromise();
    }

    public ChannelFuture newSucceededFuture() {
        return this.delegate.newSucceededFuture();
    }

    public ChannelFuture newFailedFuture(Throwable cause) {
        return this.delegate.newFailedFuture(cause);
    }

    public ChannelPromise voidPromise() {
        return this.delegate.voidPromise();
    }

    public int compareTo(Channel o) {
        return this.delegate.compareTo((Object)o);
    }

    public ChannelId id() {
        return this.delegate.id();
    }

    public EventLoop eventLoop() {
        return this.delegate.eventLoop();
    }

    public Channel parent() {
        return this.delegate.parent();
    }

    public ChannelConfig config() {
        return this.delegate.config();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public boolean isRegistered() {
        return this.delegate.isRegistered();
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public ChannelMetadata metadata() {
        return this.delegate.metadata();
    }

    public SocketAddress localAddress() {
        return this.delegate.localAddress();
    }

    public SocketAddress remoteAddress() {
        return this.delegate.remoteAddress();
    }

    public ChannelFuture closeFuture() {
        return this.delegate.closeFuture();
    }

    public boolean isWritable() {
        return this.delegate.isWritable();
    }

    public long bytesBeforeUnwritable() {
        return this.delegate.bytesBeforeUnwritable();
    }

    public long bytesBeforeWritable() {
        return this.delegate.bytesBeforeWritable();
    }

    public Channel.Unsafe unsafe() {
        return this.delegate.unsafe();
    }

    public ChannelPipeline pipeline() {
        return this.delegate.pipeline();
    }

    public ByteBufAllocator alloc() {
        return this.delegate.alloc();
    }

    public Channel read() {
        return this.delegate.read();
    }

    public Channel flush() {
        return this.delegate.flush();
    }

    public Channel bypassDelay() {
        return this.delegate;
    }

    public void delayWritesUntil(CompletableFuture<?> future) {
        DelayedWrites delayedWrites = this.delay == null ? new DelayedWrites(future) : new DelayedWrites((CompletableFuture<?>)this.delay.future.thenCompose(ignored -> future));
        this.delay = delayedWrites;
        future.whenComplete((res, err) -> {
            delayedWrites.runDelayed();
            if (this.delay == delayedWrites) {
                this.delay = null;
            }
        });
    }

    static class DelayedWrites {
        private final ArrayDeque<Runnable> delayed = new ArrayDeque();
        private final CompletableFuture<?> future;

        public DelayedWrites(CompletableFuture<?> future) {
            this.future = future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Runnable runnable) {
            ArrayDeque<Runnable> arrayDeque = this.delayed;
            synchronized (arrayDeque) {
                this.delayed.add(runnable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runDelayed() {
            ArrayDeque<Runnable> arrayDeque = this.delayed;
            synchronized (arrayDeque) {
                Runnable runnable;
                while ((runnable = this.delayed.poll()) != null) {
                    runnable.run();
                }
            }
        }
    }
}

