/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.auth.Protocol;
import java.net.InetAddress;
import java.security.cert.Certificate;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectionProperties {
    private static final Logger LOGGER = LogManager.getLogger(ConnectionProperties.class);
    private final InetAddress address;
    private final Protocol protocol;
    private final boolean hasSSL;
    @Nullable
    private final SSLSession sslSession;

    public ConnectionProperties(InetAddress address, Protocol protocol, @Nullable SSLSession sslSession) {
        this.address = address;
        this.protocol = protocol;
        this.hasSSL = sslSession != null;
        this.sslSession = sslSession;
    }

    public boolean hasSSL() {
        return this.hasSSL;
    }

    public InetAddress address() {
        return this.address;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public Certificate clientCert() {
        if (this.sslSession != null) {
            try {
                return this.sslSession.getPeerCertificates()[0];
            }
            catch (ArrayIndexOutOfBoundsException | SSLPeerUnverifiedException e) {
                LOGGER.debug("Client certificate not available", (Throwable)e);
            }
        }
        return null;
    }
}

