/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.auth.AuthenticationMethod;
import io.crate.auth.user.User;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.protocols.postgres.ConnectionProperties;
import java.io.Closeable;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.SecureString;

class AuthenticationContext
implements Closeable {
    private SecureString password;
    private final String userName;
    private final Logger logger;
    private final AuthenticationMethod authMethod;
    private final ConnectionProperties connProperties;

    AuthenticationContext(AuthenticationMethod authMethod, ConnectionProperties connProperties, String userName, Logger logger) {
        this.authMethod = authMethod;
        this.connProperties = connProperties;
        this.userName = userName;
        this.logger = logger;
        this.password = null;
    }

    @Nullable
    User authenticate() {
        User user = this.authMethod.authenticate(this.userName, this.password, this.connProperties);
        if (user != null && this.logger.isTraceEnabled()) {
            this.logger.trace("Authentication succeeded user \"{}\" and method \"{}\".", (Object)user.name(), (Object)this.authMethod.name());
        }
        return user;
    }

    void setSecurePassword(char[] secureString) {
        this.password = new SecureString(secureString);
    }

    @Nullable
    @VisibleForTesting
    SecureString password() {
        return this.password;
    }

    @Override
    public void close() {
        if (this.password != null) {
            this.password.close();
        }
    }
}

