/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;

public final class Responses {
    public static FullHttpResponse contentResponse(HttpResponseStatus status, ByteBufAllocator alloc, CharSequence body) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, ByteBufUtil.writeUtf8((ByteBufAllocator)alloc, (CharSequence)body));
        HttpUtil.setContentLength((HttpMessage)resp, (long)body.length());
        return resp;
    }

    public static FullHttpResponse contentResponse(HttpResponseStatus status, ByteBufAllocator alloc, byte[] data) {
        ByteBuf buffer = alloc.buffer(data.length);
        buffer.writeBytes(data);
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, buffer);
        HttpUtil.setContentLength((HttpMessage)resp, (long)data.length);
        return resp;
    }

    public static FullHttpResponse redirectTo(String location) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.TEMPORARY_REDIRECT);
        response.headers().add((CharSequence)HttpHeaderNames.LOCATION, (Object)location);
        HttpUtil.setContentLength((HttpMessage)response, (long)0L);
        return response;
    }
}

