/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.http;

import io.crate.common.collections.Tuple;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.elasticsearch.common.settings.SecureString;

public final class Headers {
    private static final Pattern USER_AGENT_BROWSER_PATTERN = Pattern.compile("(Mozilla|Chrome|Safari|Opera|Android|AppleWebKit)+?[/\\s][\\d.]+");
    private static final SecureString EMPTY_PASSWORD = new SecureString(new char[0]);
    private static final Tuple<String, SecureString> EMPTY_CREDENTIALS_TUPLE = new Tuple<String, SecureString>("", EMPTY_PASSWORD);

    static boolean isBrowser(@Nullable String headerValue) {
        if (headerValue == null) {
            return false;
        }
        String engine = headerValue.split("\\s+")[0];
        return USER_AGENT_BROWSER_PATTERN.matcher(engine).matches();
    }

    static boolean isAcceptJson(String headerValue) {
        return headerValue != null && headerValue.contains("application/json");
    }

    public static boolean isCloseConnection(FullHttpRequest request) {
        HttpHeaders headers = request.headers();
        return HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)headers.get((CharSequence)HttpHeaderNames.CONNECTION)) || request.protocolVersion().equals((Object)HttpVersion.HTTP_1_0) && !HttpHeaderValues.KEEP_ALIVE.contentEqualsIgnoreCase((CharSequence)headers.get((CharSequence)HttpHeaderNames.CONNECTION));
    }

    public static void setKeepAlive(HttpVersion httpVersion, FullHttpResponse resp) {
        if (httpVersion.equals((Object)HttpVersion.HTTP_1_0)) {
            resp.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"Keep-Alive");
        }
    }

    public static Tuple<String, SecureString> extractCredentialsFromHttpBasicAuthHeader(String authHeaderValue) {
        String username;
        if (authHeaderValue == null || authHeaderValue.isEmpty()) {
            return EMPTY_CREDENTIALS_TUPLE;
        }
        SecureString password = EMPTY_PASSWORD;
        String valueWithoutBasePrefix = authHeaderValue.substring(6);
        String decodedCreds = new String(Base64.getDecoder().decode(valueWithoutBasePrefix), StandardCharsets.UTF_8);
        int idx = decodedCreds.indexOf(58);
        if (idx < 0) {
            username = decodedCreds;
        } else {
            username = decodedCreds.substring(0, idx);
            String passwdStr = decodedCreds.substring(idx + 1);
            if (passwdStr.length() > 0) {
                password = new SecureString(passwdStr.toCharArray());
            }
        }
        return new Tuple<String, SecureString>(username, password);
    }
}

