/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.annotation.Nullable;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLSession;

public final class SSL {
    @Nullable
    public static String extractCN(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            return SSL.extractCN(((X509Certificate)certificate).getSubjectX500Principal().getName());
        }
        return null;
    }

    @Nullable
    public static SSLSession getSession(Channel channel) {
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
        if (sslHandler != null) {
            return sslHandler.engine().getSession();
        }
        return null;
    }

    private static String extractCN(String subjectDN) {
        try {
            LdapName ldapName = new LdapName(subjectDN);
            for (Rdn rdn : ldapName.getRdns()) {
                if (!"CN".equalsIgnoreCase(rdn.getType())) continue;
                return rdn.getValue().toString();
            }
            throw new RuntimeException("Could not extract commonName from certificate subjectDN: " + subjectDN);
        }
        catch (InvalidNameException e) {
            throw new RuntimeException("Could not extract commonName from certificate", e);
        }
    }
}

