/*
 * Decompiled with CFR 0.152.
 */
package io.crate.profile;

import io.crate.profile.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.search.profile.query.QueryProfiler;

public class ProfilingContext {
    private static final double NS_TO_MS_FACTOR = 1000000.0;
    private final HashMap<String, Double> durationInMSByTimer;
    private final List<QueryProfiler> profilers;

    public ProfilingContext(List<QueryProfiler> profilers) {
        this.profilers = profilers;
        this.durationInMSByTimer = new HashMap();
    }

    public Map<String, Object> getDurationInMSByTimer() {
        HashMap<String, Double> builder = new HashMap<String, Double>(this.durationInMSByTimer);
        ArrayList<Map<String, Object>> queryTimings = new ArrayList<Map<String, Object>>();
        for (QueryProfiler profiler : this.profilers) {
            for (ProfileResult profileResult : profiler.getTree()) {
                queryTimings.add(ProfilingContext.resultAsMap(profileResult));
            }
        }
        if (!queryTimings.isEmpty()) {
            builder.put("QueryBreakdown", (Double)((Object)queryTimings));
        }
        return Collections.unmodifiableMap(builder);
    }

    private static Map<String, Object> resultAsMap(ProfileResult profileResult) {
        HashMap<String, Object> queryTimingsBuilder = new HashMap<String, Object>();
        queryTimingsBuilder.put("QueryName", profileResult.getQueryName());
        queryTimingsBuilder.put("QueryDescription", profileResult.getLuceneDescription());
        queryTimingsBuilder.put("Time", (double)profileResult.getTime() / 1000000.0);
        queryTimingsBuilder.put("BreakDown", profileResult.getTimeBreakdown().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((String)e.getKey()).endsWith("_count") ? (double)((Long)e.getValue()).longValue() : (double)((Long)e.getValue()).longValue() / 1000000.0)));
        List children = profileResult.getProfiledChildren().stream().map(ProfilingContext::resultAsMap).collect(Collectors.toList());
        if (!children.isEmpty()) {
            queryTimingsBuilder.put("Children", children);
        }
        return Collections.unmodifiableMap(queryTimingsBuilder);
    }

    public Timer createAndStartTimer(String name) {
        Timer timer = this.createTimer(name);
        timer.start();
        return timer;
    }

    public void stopTimerAndStoreDuration(Timer timer) {
        timer.stop();
        this.durationInMSByTimer.put(timer.name(), (double)timer.durationNanos() / 1000000.0);
    }

    public Timer createTimer(String name) {
        return new Timer(name);
    }

    public static String generateProfilingKey(int id, String name) {
        return id + "-" + name;
    }
}

