/*
 * Decompiled with CFR 0.152.
 */
package io.crate.plugin;

import com.google.common.collect.ImmutableList;
import io.crate.action.sql.SQLOperations;
import io.crate.auth.AuthSettings;
import io.crate.cluster.gracefulstop.DecommissionAllocationDecider;
import io.crate.cluster.gracefulstop.DecommissioningService;
import io.crate.execution.TransportExecutorModule;
import io.crate.execution.engine.collect.CollectOperationModule;
import io.crate.execution.engine.collect.files.FileCollectModule;
import io.crate.execution.engine.collect.stats.JobsLogService;
import io.crate.execution.jobs.JobModule;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.transport.NodeDisconnectJobMonitorService;
import io.crate.expression.operator.OperatorModule;
import io.crate.expression.predicate.PredicateModule;
import io.crate.expression.reference.sys.check.SysChecksModule;
import io.crate.expression.reference.sys.check.node.SysNodeChecksModule;
import io.crate.expression.udf.UserDefinedFunctionsMetadata;
import io.crate.license.CeLicenseModule;
import io.crate.license.LicenseExtension;
import io.crate.lucene.ArrayMapperService;
import io.crate.metadata.CustomMetadataUpgraderLoader;
import io.crate.metadata.DanglingArtifactsService;
import io.crate.metadata.DefaultTemplateService;
import io.crate.metadata.MetadataModule;
import io.crate.metadata.Schemas;
import io.crate.metadata.blob.MetadataBlobModule;
import io.crate.metadata.information.MetadataInformationModule;
import io.crate.metadata.pgcatalog.PgCatalogModule;
import io.crate.metadata.settings.AnalyzerSettings;
import io.crate.metadata.settings.CrateSettings;
import io.crate.metadata.sys.MetadataSysModule;
import io.crate.metadata.upgrade.IndexTemplateUpgrader;
import io.crate.metadata.upgrade.MetadataIndexUpgrader;
import io.crate.metadata.view.ViewsMetadata;
import io.crate.module.CrateCommonModule;
import io.crate.monitor.MonitorModule;
import io.crate.plugin.EnterpriseLoader;
import io.crate.plugin.IndexEventListenerProxy;
import io.crate.plugin.SQLModule;
import io.crate.protocols.postgres.PostgresNetty;
import io.crate.protocols.ssl.SslConfigSettings;
import io.crate.protocols.ssl.SslContextProviderFallbackModule;
import io.crate.protocols.ssl.SslExtension;
import io.crate.settings.CrateSetting;
import io.crate.user.UserExtension;
import io.crate.user.UserFallbackModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.elasticsearch.action.bulk.BulkModule;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.mapper.ArrayTypeParser;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;

public class SQLPlugin
extends Plugin
implements ActionPlugin,
MapperPlugin,
ClusterPlugin {
    private final Settings settings;
    @Nullable
    private final UserExtension userExtension;
    @Nullable
    private final LicenseExtension licenseExtension;
    @Nullable
    private final SslExtension sslExtension;
    private final IndexEventListenerProxy indexEventListenerProxy;

    public SQLPlugin(Settings settings) {
        this.settings = settings;
        this.indexEventListenerProxy = new IndexEventListenerProxy();
        this.userExtension = EnterpriseLoader.loadSingle(UserExtension.class);
        this.licenseExtension = EnterpriseLoader.loadSingle(LicenseExtension.class);
        this.sslExtension = EnterpriseLoader.loadSingle(SslExtension.class);
    }

    @Override
    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.add(AnalyzerSettings.CUSTOM_ANALYSIS_SETTING_GROUP);
        settings.add(SQLOperations.NODE_READ_ONLY_SETTING);
        settings.add(PostgresNetty.PSQL_ENABLED_SETTING.setting());
        settings.add(PostgresNetty.PSQL_PORT_SETTING.setting());
        settings.add(AuthSettings.AUTH_HOST_BASED_ENABLED_SETTING.setting());
        settings.add(AuthSettings.AUTH_HOST_BASED_CONFIG_SETTING.setting());
        settings.add(AuthSettings.AUTH_TRUST_HTTP_DEFAULT_HEADER.setting());
        settings.add(SslConfigSettings.SSL_HTTP_ENABLED.setting());
        settings.add(SslConfigSettings.SSL_PSQL_ENABLED.setting());
        settings.add(SslConfigSettings.SSL_TRUSTSTORE_FILEPATH.setting());
        settings.add(SslConfigSettings.SSL_TRUSTSTORE_PASSWORD.setting());
        settings.add(SslConfigSettings.SSL_KEYSTORE_FILEPATH.setting());
        settings.add(SslConfigSettings.SSL_KEYSTORE_PASSWORD.setting());
        settings.add(SslConfigSettings.SSL_KEYSTORE_KEY_PASSWORD.setting());
        settings.add(SslConfigSettings.SSL_RESOURCE_POLL_INTERVAL.setting());
        for (CrateSetting<?> crateSetting : CrateSettings.CRATE_CLUSTER_SETTINGS) {
            settings.add(crateSetting.setting());
        }
        return settings;
    }

    @Override
    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        ImmutableList.Builder builder = ImmutableList.builder().add(DecommissioningService.class).add(NodeDisconnectJobMonitorService.class).add(JobsLogService.class).add(PostgresNetty.class).add(TasksService.class).add(Schemas.class).add(DefaultTemplateService.class).add(ArrayMapperService.class).add(DanglingArtifactsService.class);
        if (this.licenseExtension != null) {
            builder.addAll(this.licenseExtension.getGuiceServiceClasses());
        }
        if (this.sslExtension != null) {
            builder.addAll(this.sslExtension.getGuiceServiceClasses());
        }
        return builder.build();
    }

    @Override
    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(new SQLModule());
        modules.add(new CrateCommonModule(this.indexEventListenerProxy));
        modules.add(new TransportExecutorModule());
        modules.add(new JobModule());
        modules.add(new CollectOperationModule());
        modules.add(new FileCollectModule());
        modules.add(new MetadataModule());
        modules.add(new MetadataSysModule());
        modules.add(new MetadataBlobModule());
        modules.add(new PgCatalogModule());
        modules.add(new MetadataInformationModule());
        modules.add(new OperatorModule());
        modules.add(new PredicateModule());
        modules.add(new MonitorModule());
        modules.add(new BulkModule());
        modules.add(new SysChecksModule());
        modules.add(new SysNodeChecksModule());
        if (this.userExtension != null) {
            modules.addAll(this.userExtension.getModules(this.settings));
        } else {
            modules.add(new UserFallbackModule());
        }
        if (this.licenseExtension != null) {
            modules.addAll(this.licenseExtension.getModules(this.settings));
        } else {
            modules.add(new CeLicenseModule());
        }
        if (this.sslExtension != null) {
            modules.addAll(this.sslExtension.getModules());
        } else {
            modules.add(new SslContextProviderFallbackModule());
        }
        return modules;
    }

    @Override
    public Map<String, Mapper.TypeParser> getMappers() {
        return Collections.singletonMap("array", new ArrayTypeParser());
    }

    @Override
    public Collection<AllocationDecider> createAllocationDeciders(Settings settings, ClusterSettings clusterSettings) {
        return ImmutableList.of((Object)new DecommissionAllocationDecider(settings, clusterSettings));
    }

    @Override
    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.add(new NamedWriteableRegistry.Entry(Metadata.Custom.class, "user_defined_functions", UserDefinedFunctionsMetadata::new));
        entries.add(new NamedWriteableRegistry.Entry(Metadata.Custom.class, "views", ViewsMetadata::new));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "user_defined_functions", in -> UserDefinedFunctionsMetadata.readDiffFrom(Metadata.Custom.class, "user_defined_functions", in)));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "views", in -> ViewsMetadata.readDiffFrom(Metadata.Custom.class, "views", in)));
        if (this.userExtension != null) {
            entries.addAll(this.userExtension.getNamedWriteables());
        }
        if (this.licenseExtension != null) {
            entries.addAll(this.licenseExtension.getNamedWriteables());
        }
        return entries;
    }

    @Override
    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("user_defined_functions", new String[0]), UserDefinedFunctionsMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("views", new String[0]), ViewsMetadata::fromXContent));
        if (this.userExtension != null) {
            entries.addAll(this.userExtension.getNamedXContent());
        }
        if (this.licenseExtension != null) {
            entries.addAll(this.licenseExtension.getNamedXContent());
        }
        return entries;
    }

    @Override
    public UnaryOperator<IndexMetadata> getIndexMetadataUpgrader() {
        return new MetadataIndexUpgrader();
    }

    @Override
    public UnaryOperator<Map<String, Metadata.Custom>> getCustomMetadataUpgrader() {
        return new CustomMetadataUpgraderLoader(this.settings);
    }

    @Override
    public UnaryOperator<Map<String, IndexTemplateMetadata>> getIndexTemplateMetadataUpgrader() {
        return new IndexTemplateUpgrader();
    }

    @Override
    public void onIndexModule(IndexModule indexModule) {
        indexModule.addIndexEventListener(this.indexEventListenerProxy);
    }
}

