/*
 * Decompiled with CFR 0.152.
 */
package io.crate.plugin;

import com.google.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.plugin.PluginLoader;
import io.crate.plugin.SQLPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;

public class PluginLoaderPlugin
extends Plugin
implements ActionPlugin,
MapperPlugin,
ClusterPlugin {
    private static final Logger LOGGER = LogManager.getLogger(PluginLoaderPlugin.class);
    @VisibleForTesting
    final PluginLoader pluginLoader;
    @VisibleForTesting
    final Settings settings;
    private final SQLPlugin sqlPlugin;
    private final Settings additionalSettings;
    private final List<Setting<?>> settingList = new ArrayList();

    public PluginLoaderPlugin(Settings settings) {
        this.pluginLoader = new PluginLoader(settings);
        this.settings = Settings.builder().put(this.pluginLoader.additionalSettings()).put(settings).build();
        this.sqlPlugin = new SQLPlugin(this.settings);
        this.additionalSettings = Settings.builder().put(this.pluginLoader.additionalSettings()).put(this.sqlPlugin.additionalSettings()).build();
        this.settingList.add(PluginLoader.SETTING_CRATE_PLUGINS_PATH);
        this.settingList.addAll(this.pluginLoader.getSettings());
        this.settingList.addAll(this.sqlPlugin.getSettings());
    }

    @Override
    public Settings additionalSettings() {
        return this.additionalSettings;
    }

    @Override
    public List<Setting<?>> getSettings() {
        return this.settingList;
    }

    @Override
    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        return Lists2.concat(this.sqlPlugin.getGuiceServiceClasses(), this.pluginLoader.getGuiceServiceClasses());
    }

    @Override
    public Collection<Module> createGuiceModules() {
        return Lists2.concat(this.pluginLoader.createGuiceModules(), this.sqlPlugin.createGuiceModules());
    }

    @Override
    public Map<String, Mapper.TypeParser> getMappers() {
        return this.sqlPlugin.getMappers();
    }

    @Override
    public Collection<AllocationDecider> createAllocationDeciders(Settings settings, ClusterSettings clusterSettings) {
        return this.sqlPlugin.createAllocationDeciders(settings, clusterSettings);
    }

    @Override
    public void onIndexModule(IndexModule indexModule) {
        this.sqlPlugin.onIndexModule(indexModule);
    }

    @Override
    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return this.sqlPlugin.getNamedWriteables();
    }

    @Override
    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return this.sqlPlugin.getNamedXContent();
    }

    @Override
    public UnaryOperator<IndexMetadata> getIndexMetadataUpgrader() {
        return this.sqlPlugin.getIndexMetadataUpgrader();
    }

    @Override
    public UnaryOperator<Map<String, IndexTemplateMetadata>> getIndexTemplateMetadataUpgrader() {
        return this.sqlPlugin.getIndexTemplateMetadataUpgrader();
    }
}

