/*
 * Decompiled with CFR 0.152.
 */
package io.crate.plugin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.crate.Plugin;
import io.crate.plugin.PluginException;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xbean.finder.ResourceFinder;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class PluginLoader {
    static final Setting<String> SETTING_CRATE_PLUGINS_PATH = Setting.simpleString("path.crate_plugins", Setting.Property.NodeScope);
    private static final String RESOURCE_PATH = "META-INF/services/";
    private static final String ENTERPRISE_FOLDER_NAME = "enterprise";
    private final Settings settings;
    private final Logger logger;
    @VisibleForTesting
    final List<Plugin> plugins;
    private final Path pluginsPath;
    private final List<URL> jarsToLoad = new ArrayList<URL>();

    PluginLoader(Settings settings) {
        this.settings = settings;
        String pluginFolder = SETTING_CRATE_PLUGINS_PATH.get(settings);
        this.pluginsPath = pluginFolder.isEmpty() ? PathUtils.get(settings.get("path.home"), new String[0]).normalize().resolve("plugins") : PathUtils.get(pluginFolder, new String[0]).normalize();
        this.logger = LogManager.getLogger((String)this.getClass().getPackage().getName());
        Collection<Class<? extends Plugin>> implementations = this.findImplementations();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Class<? extends Plugin> pluginClass : implementations) {
            try {
                builder.add((Object)this.loadPlugin(pluginClass));
            }
            catch (Throwable t) {
                this.logger.error("error loading plugin:  " + pluginClass.getSimpleName(), t);
            }
        }
        this.plugins = builder.build();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("plugins loaded: {} ", this.plugins.stream().map(Plugin::name).collect(Collectors.toList()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<Class<? extends Plugin>> findImplementations() {
        File[] allPlugins;
        if (!FileSystemUtils.isAccessibleDirectory(this.pluginsPath, this.logger)) {
            return Collections.emptyList();
        }
        File[] plugins = this.pluginsPath.toFile().listFiles(file -> !file.getName().equals(ENTERPRISE_FOLDER_NAME));
        if (plugins == null) {
            return Collections.emptyList();
        }
        File enterprisePluginDir = new File(this.pluginsPath.toFile(), ENTERPRISE_FOLDER_NAME);
        File[] enterpriseFiles = enterprisePluginDir.listFiles();
        if (enterpriseFiles != null) {
            allPlugins = Arrays.copyOf(plugins, plugins.length + enterpriseFiles.length);
            System.arraycopy(enterpriseFiles, 0, allPlugins, plugins.length, enterpriseFiles.length);
        } else {
            allPlugins = plugins;
        }
        ArrayList<Class<? extends Plugin>> allImplementations = new ArrayList<Class<? extends Plugin>>();
        File[] fileArray = allPlugins;
        int n = fileArray.length;
        int n2 = 0;
        while (true) {
            block22: {
                if (n2 >= n) {
                    return allImplementations;
                }
                File plugin = fileArray[n2];
                if (!plugin.canRead()) {
                    this.logger.debug("[{}] is not readable.", (Object)plugin.getAbsolutePath());
                } else {
                    String msg;
                    block21: {
                        Path esDescriptorFile = plugin.toPath().resolve("plugin-descriptor.properties");
                        try {
                            if (!esDescriptorFile.toFile().exists()) break block21;
                            break block22;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ArrayList<URL> pluginUrls = new ArrayList<URL>();
                    this.logger.trace("--- adding plugin [{}]", (Object)plugin.getAbsolutePath());
                    try {
                        URL pluginURL = plugin.toURI().toURL();
                        try {
                            this.checkJarHell(pluginURL);
                        }
                        catch (Exception e) {
                            String msg2 = String.format(Locale.ENGLISH, "failed to load plugin %s due to jar hell", pluginURL);
                            this.logger.error(msg2, (Throwable)e);
                            throw new RuntimeException(msg2, e);
                        }
                        pluginUrls.add(pluginURL);
                        if (!plugin.isFile()) {
                            File[] pluginLibFiles;
                            File libLocation;
                            ArrayList<File> libFiles = new ArrayList<File>();
                            File[] pluginFiles = plugin.listFiles();
                            if (pluginFiles != null) {
                                libFiles.addAll(Arrays.asList(pluginFiles));
                            }
                            if ((libLocation = new File(plugin, "lib")).exists() && libLocation.isDirectory() && (pluginLibFiles = libLocation.listFiles()) != null) {
                                libFiles.addAll(Arrays.asList(pluginLibFiles));
                            }
                            for (File libFile : libFiles) {
                                if (!libFile.getName().endsWith(".jar") && !libFile.getName().endsWith(".zip")) continue;
                                URL libURL = libFile.toURI().toURL();
                                try {
                                    this.checkJarHell(libURL);
                                    pluginUrls.add(libURL);
                                }
                                catch (Exception e) {
                                    String msg3 = String.format(Locale.ENGLISH, "Library %s of plugin %s already loaded", libURL, pluginURL);
                                    this.logger.error(msg3, (Throwable)e);
                                    throw new RuntimeException(msg3, e);
                                }
                            }
                        }
                    }
                    catch (MalformedURLException e) {
                        msg = String.format(Locale.ENGLISH, "failed to add plugin [%s]", plugin);
                        this.logger.error(msg, (Throwable)e);
                        throw new RuntimeException(msg, e);
                    }
                    Collection<Class<? extends Plugin>> implementations = this.findImplementations(pluginUrls);
                    if (implementations == null || implementations.isEmpty()) {
                        msg = String.format(Locale.ENGLISH, "Path [%s] does not contain a valid CrateDB plugin", plugin.getAbsolutePath());
                        RuntimeException e = new RuntimeException(msg);
                        this.logger.error(msg, (Throwable)e);
                        throw e;
                    }
                    this.jarsToLoad.addAll(pluginUrls);
                    allImplementations.addAll(implementations);
                }
            }
            ++n2;
        }
    }

    @Nullable
    private Collection<Class<? extends Plugin>> findImplementations(Collection<URL> pluginUrls) {
        URL[] urls = pluginUrls.toArray(new URL[pluginUrls.size()]);
        URLClassLoader loader = URLClassLoader.newInstance(urls, this.getClass().getClassLoader());
        ResourceFinder finder = new ResourceFinder(RESOURCE_PATH, (ClassLoader)loader, urls);
        try {
            return finder.findAllImplementations(Plugin.class);
        }
        catch (ClassCastException e) {
            this.logger.error("plugin does not implement io.crate.Plugin interface", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("error while loading plugin, misconfigured plugin", (Throwable)e);
        }
        catch (Throwable t) {
            this.logger.error("error while loading plugins", t);
        }
        return null;
    }

    private Plugin loadPlugin(Class<? extends Plugin> pluginClass) {
        try {
            Constructor<? extends Plugin> constructor = pluginClass.getConstructor(Settings.class);
            try {
                return constructor.newInstance(this.settings);
            }
            catch (Exception e) {
                throw new PluginException("Failed to create plugin [" + pluginClass + "]", e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<? extends Plugin> constructor = pluginClass.getConstructor(new Class[0]);
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e1) {
                    throw new PluginException("Failed to create plugin [" + pluginClass + "]", e);
                }
            }
            catch (NoSuchMethodException e1) {
                throw new PluginException("No constructor for [" + pluginClass + "]");
            }
        }
    }

    Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Plugin plugin : this.plugins) {
            modules.addAll(plugin.createGuiceModules());
        }
        return modules;
    }

    Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        ArrayList<Class<? extends LifecycleComponent>> services = new ArrayList<Class<? extends LifecycleComponent>>();
        for (Plugin plugin : this.plugins) {
            services.addAll(plugin.getGuiceServiceClasses());
        }
        return services;
    }

    Settings additionalSettings() {
        Settings.Builder builder = Settings.builder();
        for (Plugin plugin : this.plugins) {
            builder.put(plugin.additionalSettings());
        }
        return builder.build();
    }

    List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        for (Plugin plugin : this.plugins) {
            settings.addAll(plugin.getSettings());
        }
        return settings;
    }

    private void checkJarHell(URL url) throws Exception {
        HashSet<URL> jarHellSet = new HashSet<URL>();
        jarHellSet.addAll(JarHell.parseClassPath());
        jarHellSet.addAll(this.jarsToLoad);
        jarHellSet.add(url);
        JarHell.checkJarHell(jarHellSet, output -> {});
    }
}

