/*
 * Decompiled with CFR 0.152.
 */
package io.crate.plugin;

import io.crate.protocols.ssl.SslConfigSettings;
import io.crate.protocols.ssl.SslContextProvider;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.netty4.cors.Netty4CorsConfig;

@Singleton
public class PipelineRegistry {
    private static final Logger LOGGER = LogManager.getLogger(PipelineRegistry.class);
    private final List<ChannelPipelineItem> addBeforeList = new ArrayList<ChannelPipelineItem>();
    private final Settings settings;
    @Nullable
    private SslContextProvider sslContextProvider;

    public PipelineRegistry(Settings settings) {
        this.settings = settings;
    }

    public void setSslContextProvider(SslContextProvider sslContextProvider) {
        if (SslConfigSettings.isHttpsEnabled(this.settings)) {
            LOGGER.info("HTTP SSL support is enabled.");
            this.sslContextProvider = sslContextProvider;
        } else {
            LOGGER.info("HTTP SSL support is disabled.");
            this.sslContextProvider = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBefore(ChannelPipelineItem item) {
        List<ChannelPipelineItem> list = this.addBeforeList;
        synchronized (list) {
            this.addSorted(this.addBeforeList, item);
        }
    }

    public void registerItems(ChannelPipeline pipeline, Netty4CorsConfig corsConfig) {
        SslContext sslContext;
        for (ChannelPipelineItem item : this.addBeforeList) {
            pipeline.addBefore(item.base, item.name, item.handlerFactory.apply(corsConfig));
        }
        if (this.sslContextProvider != null && (sslContext = this.sslContextProvider.getSslContext()) != null) {
            SslHandler sslHandler = sslContext.newHandler(pipeline.channel().alloc());
            pipeline.addFirst(new ChannelHandler[]{sslHandler});
        }
    }

    List<ChannelPipelineItem> addBeforeList() {
        return this.addBeforeList;
    }

    private void addSorted(List<ChannelPipelineItem> pipelineItems, ChannelPipelineItem newItem) {
        pipelineItems.add(newItem);
        if (pipelineItems.size() < 2) {
            return;
        }
        ArrayList<ChannelPipelineItem> copy = new ArrayList<ChannelPipelineItem>(pipelineItems.size());
        copy.addAll(pipelineItems);
        for (ChannelPipelineItem item : copy) {
            pipelineItems.remove(item);
            boolean prev = false;
            int prevIdx = 0;
            for (ChannelPipelineItem o : pipelineItems) {
                if (o.name.equals(item.base)) {
                    prev = true;
                    break;
                }
                ++prevIdx;
            }
            if (prev) {
                pipelineItems.add(prevIdx + 1, item);
                continue;
            }
            boolean next = false;
            int nextIdx = 0;
            for (ChannelPipelineItem o : pipelineItems) {
                if (o.base.equals(item.name)) {
                    next = true;
                    break;
                }
                ++nextIdx;
            }
            if (next) {
                pipelineItems.add(nextIdx, item);
                continue;
            }
            pipelineItems.add(item);
        }
    }

    public static class ChannelPipelineItem {
        final String base;
        final String name;
        final Function<Netty4CorsConfig, ChannelHandler> handlerFactory;

        public ChannelPipelineItem(String base, String name, Function<Netty4CorsConfig, ChannelHandler> handlerFactory) {
            this.base = base;
            this.name = name;
            this.handlerFactory = handlerFactory;
        }

        public String toString() {
            return "ChannelPipelineItem{base='" + this.base + "', name='" + this.name + "'}";
        }
    }
}

