/*
 * Decompiled with CFR 0.152.
 */
package io.crate.plugin;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;

public class IndexEventListenerProxy
implements IndexEventListener {
    private final List<IndexEventListener> listeners = new ArrayList<IndexEventListener>();

    public void addFirst(IndexEventListener indexEventListener) {
        this.listeners.add(0, indexEventListener);
    }

    public void addLast(IndexEventListener indexEventListener) {
        this.listeners.add(indexEventListener);
    }

    @Override
    public void shardRoutingChanged(IndexShard indexShard, @Nullable ShardRouting oldRouting, ShardRouting newRouting) {
        for (IndexEventListener listener : this.listeners) {
            listener.shardRoutingChanged(indexShard, oldRouting, newRouting);
        }
    }

    @Override
    public void afterIndexShardCreated(IndexShard indexShard) {
        for (IndexEventListener listener : this.listeners) {
            listener.afterIndexShardCreated(indexShard);
        }
    }

    @Override
    public void afterIndexShardStarted(IndexShard indexShard) {
        for (IndexEventListener listener : this.listeners) {
            listener.afterIndexShardStarted(indexShard);
        }
    }

    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            listener.beforeIndexShardClosed(shardId, indexShard, indexSettings);
        }
    }

    @Override
    public void afterIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            listener.afterIndexShardClosed(shardId, indexShard, indexSettings);
        }
    }

    @Override
    public void indexShardStateChanged(IndexShard indexShard, @Nullable IndexShardState previousState, IndexShardState currentState, @Nullable String reason) {
        for (IndexEventListener listener : this.listeners) {
            listener.indexShardStateChanged(indexShard, previousState, currentState, reason);
        }
    }

    @Override
    public void onShardInactive(IndexShard indexShard) {
        for (IndexEventListener listener : this.listeners) {
            listener.onShardInactive(indexShard);
        }
    }

    @Override
    public void beforeIndexCreated(Index index, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            listener.beforeIndexCreated(index, indexSettings);
        }
    }

    @Override
    public void afterIndexCreated(IndexService indexService) {
        for (IndexEventListener listener : this.listeners) {
            listener.afterIndexCreated(indexService);
        }
    }

    @Override
    public void beforeIndexShardCreated(ShardId shardId, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            listener.beforeIndexShardCreated(shardId, indexSettings);
        }
    }

    @Override
    public void beforeIndexRemoved(IndexService indexService, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        for (IndexEventListener listener : this.listeners) {
            listener.beforeIndexRemoved(indexService, reason);
        }
    }

    @Override
    public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        for (IndexEventListener listener : this.listeners) {
            listener.afterIndexRemoved(index, indexSettings, reason);
        }
    }

    @Override
    public void beforeIndexShardDeleted(ShardId shardId, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            listener.beforeIndexShardDeleted(shardId, indexSettings);
        }
    }

    @Override
    public void afterIndexShardDeleted(ShardId shardId, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            listener.afterIndexShardDeleted(shardId, indexSettings);
        }
    }

    @Override
    public void beforeIndexAddedToCluster(Index index, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            listener.beforeIndexAddedToCluster(index, indexSettings);
        }
    }

    @Override
    public void onStoreClosed(ShardId shardId) {
        for (IndexEventListener listener : this.listeners) {
            listener.onStoreClosed(shardId);
        }
    }
}

