/*
 * Decompiled with CFR 0.152.
 */
package io.crate.plugin;

import io.crate.blob.BlobModule;
import io.crate.blob.BlobService;
import io.crate.blob.DeleteBlobAction;
import io.crate.blob.PutChunkAction;
import io.crate.blob.StartBlobAction;
import io.crate.blob.TransportDeleteBlobAction;
import io.crate.blob.TransportPutChunkAction;
import io.crate.blob.TransportStartBlobAction;
import io.crate.blob.v2.BlobIndicesModule;
import io.crate.blob.v2.BlobIndicesService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;

public class BlobPlugin
extends Plugin
implements ActionPlugin {
    private final Settings settings;

    public BlobPlugin(Settings settings) {
        this.settings = settings;
    }

    public String name() {
        return "blob";
    }

    public String description() {
        return "Plugin that adds BLOB support to CrateDB";
    }

    @Override
    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>(2);
        modules.add(new BlobModule());
        if (Node.NODE_DATA_SETTING.get(this.settings).booleanValue()) {
            modules.add(new BlobIndicesModule());
        }
        return modules;
    }

    @Override
    public List<Setting<?>> getSettings() {
        return Arrays.asList(BlobIndicesService.SETTING_BLOBS_PATH, BlobIndicesService.SETTING_INDEX_BLOBS_ENABLED, BlobIndicesService.SETTING_INDEX_BLOBS_PATH);
    }

    @Override
    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        return List.of(BlobService.class);
    }

    @Override
    public List<ActionPlugin.ActionHandler<? extends TransportRequest, ? extends TransportResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler(PutChunkAction.INSTANCE, TransportPutChunkAction.class, new Class[0]), new ActionPlugin.ActionHandler(StartBlobAction.INSTANCE, TransportStartBlobAction.class, new Class[0]), new ActionPlugin.ActionHandler(DeleteBlobAction.INSTANCE, TransportDeleteBlobAction.class, new Class[0]));
    }
}

