/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.statement;

import io.crate.action.sql.SessionContext;
import io.crate.analyze.SymbolEvaluator;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.settings.CrateSettings;
import io.crate.metadata.settings.session.SessionSetting;
import io.crate.metadata.settings.session.SessionSettingRegistry;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.Assignment;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetSessionPlan
implements Plan {
    private static final Logger LOGGER = LogManager.getLogger(SetSessionPlan.class);
    private final List<Assignment<Symbol>> settings;
    private final SessionSettingRegistry sessionSettingRegistry;

    public SetSessionPlan(List<Assignment<Symbol>> settings, SessionSettingRegistry sessionSettingRegistry) {
        this.settings = settings;
        this.sessionSettingRegistry = sessionSettingRegistry;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.MANAGEMENT;
    }

    @Override
    public void executeOrFail(DependencyCarrier executor, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), x, params, subQueryResults);
        SessionContext sessionContext = plannerContext.transactionContext().sessionContext();
        Assignment<Symbol> assignment = this.settings.get(0);
        String settingName = eval.apply(assignment.columnName()).toString();
        SetSessionPlan.validateSetting(settingName);
        SessionSetting<?> sessionSetting = this.sessionSettingRegistry.settings().get(settingName);
        if (sessionSetting == null) {
            LOGGER.info("SET SESSION STATEMENT WILL BE IGNORED: {}", (Object)settingName);
        } else {
            sessionSetting.apply(sessionContext, assignment.expressions(), eval);
        }
        consumer.accept(InMemoryBatchIterator.empty(SentinelRow.SENTINEL), null);
    }

    @VisibleForTesting
    static void validateSetting(String settingName) {
        List<String> nameParts = CrateSettings.settingNamesByPrefix(settingName);
        if (nameParts.size() != 0) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "GLOBAL Cluster setting '%s' cannot be used with SET SESSION / LOCAL", settingName));
        }
    }
}

