/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.statement;

import io.crate.action.sql.SessionContext;
import io.crate.analyze.AnalyzedSetSessionAuthorizationStatement;
import io.crate.auth.user.User;
import io.crate.auth.user.UserManager;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;

public class SetSessionAuthorizationPlan
implements Plan {
    private final AnalyzedSetSessionAuthorizationStatement setSessionAuthorization;
    private final UserManager userManager;

    public SetSessionAuthorizationPlan(AnalyzedSetSessionAuthorizationStatement setSessionAuthorization, UserManager userManager) {
        this.setSessionAuthorization = setSessionAuthorization;
        this.userManager = userManager;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.MANAGEMENT;
    }

    @Override
    public void executeOrFail(DependencyCarrier executor, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        User user;
        SessionContext sessionContext = plannerContext.transactionContext().sessionContext();
        String userName = this.setSessionAuthorization.user();
        if (userName != null) {
            user = this.userManager.findUser(userName);
            if (user == null) {
                throw new IllegalArgumentException("User '" + userName + "' does not exist.");
            }
        } else {
            user = sessionContext.authenticatedUser();
        }
        sessionContext.setSessionUser(user);
        consumer.accept(InMemoryBatchIterator.empty(SentinelRow.SENTINEL), null);
    }
}

