/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.statement;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.crate.action.sql.SessionContext;
import io.crate.analyze.AnalyzedDeleteStatement;
import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.common.collections.Lists2;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.dsl.phases.NodeOperationTree;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.projection.DeleteProjection;
import io.crate.execution.dsl.projection.MergeCountProjection;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.engine.NodeOperationTreeGenerator;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.metadata.IndexParts;
import io.crate.metadata.Reference;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.MultiPhasePlan;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.SubqueryPlanner;
import io.crate.planner.WhereClauseOptimizer;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.node.ddl.DeleteAllPartitions;
import io.crate.planner.node.ddl.DeletePartitions;
import io.crate.planner.node.dml.DeleteById;
import io.crate.planner.node.dql.Collect;
import io.crate.planner.operators.SubQueryResults;
import io.crate.planner.optimizer.symbol.Optimizer;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;

public final class DeletePlanner {
    public static Plan planDelete(AnalyzedDeleteStatement delete, SubqueryPlanner subqueryPlanner, PlannerContext context) {
        Plan plan = DeletePlanner.planDelete(delete, context);
        return MultiPhasePlan.createIfNeeded(plan, subqueryPlanner.planSubQueries(delete));
    }

    private static Plan planDelete(AnalyzedDeleteStatement delete, PlannerContext context) {
        boolean hasNonPartitionReferences;
        DocTableRelation tableRel = delete.relation();
        DocTableInfo table = (DocTableInfo)tableRel.tableInfo();
        EvaluatingNormalizer normalizer = EvaluatingNormalizer.functionOnlyNormalizer(context.nodeContext());
        WhereClauseOptimizer.DetailedQuery detailedQuery = WhereClauseOptimizer.optimize(normalizer, delete.query(), table, context.transactionContext(), context.nodeContext());
        if (!detailedQuery.partitions().isEmpty() && !(hasNonPartitionReferences = SymbolVisitors.any(s -> s instanceof Reference && !table.partitionedByColumns().contains(s), detailedQuery.query()))) {
            return new DeletePartitions(table.ident(), detailedQuery.partitions());
        }
        if (detailedQuery.docKeys().isPresent()) {
            return new DeleteById((DocTableInfo)tableRel.tableInfo(), detailedQuery.docKeys().get());
        }
        Symbol query = detailedQuery.query();
        if (table.isPartitioned() && query instanceof Input && DataTypes.BOOLEAN.sanitizeValue(((Input)((Object)query)).value()).booleanValue()) {
            return new DeleteAllPartitions(Lists2.map(table.partitions(), IndexParts::toIndexName));
        }
        return new Delete(tableRel, detailedQuery);
    }

    private static ExecutionPlan deleteByQuery(DocTableRelation table, PlannerContext context, WhereClause where) {
        DocTableInfo tableInfo = (DocTableInfo)table.tableInfo();
        Reference idReference = Objects.requireNonNull(tableInfo.getReference(DocSysColumns.ID), "Table has to have a _id reference");
        DeleteProjection deleteProjection = new DeleteProjection(new InputColumn(0, idReference.valueType()));
        SessionContext sessionContext = context.transactionContext().sessionContext();
        Routing routing = context.allocateRouting(tableInfo, where, RoutingProvider.ShardSelection.PRIMARIES, sessionContext);
        RoutedCollectPhase collectPhase = new RoutedCollectPhase(context.jobId(), context.nextExecutionPhaseId(), "collect", routing, tableInfo.rowGranularity(), Lists.newArrayList((Object[])new Symbol[]{idReference}), (List<Projection>)ImmutableList.of((Object)deleteProjection), Optimizer.optimizeCasts(where.queryOrFallback(), context), DistributionInfo.DEFAULT_BROADCAST);
        Collect collect = new Collect(collectPhase, -1, 0, 1, 1, null);
        return Merge.ensureOnHandler(collect, context, Collections.singletonList(MergeCountProjection.INSTANCE));
    }

    static class Delete
    implements Plan {
        private final DocTableRelation table;
        private final WhereClauseOptimizer.DetailedQuery detailedQuery;

        public Delete(DocTableRelation table, WhereClauseOptimizer.DetailedQuery detailedQuery) {
            this.table = table;
            this.detailedQuery = detailedQuery;
        }

        @Override
        public Plan.StatementType type() {
            return Plan.StatementType.DELETE;
        }

        @Override
        public void executeOrFail(DependencyCarrier executor, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
            WhereClause where = this.detailedQuery.toBoundWhereClause((DocTableInfo)this.table.tableInfo(), params, subQueryResults, plannerContext.transactionContext(), executor.nodeContext());
            if (!(where.partitions().isEmpty() || where.hasQuery() && !Literal.BOOLEAN_TRUE.equals(where.query()))) {
                DeleteIndexRequest request = new DeleteIndexRequest(where.partitions().toArray(new String[0]));
                request.indicesOptions(IndicesOptions.lenientExpandOpen());
                executor.transportActionProvider().transportDeleteIndexAction().execute(request, new OneRowActionListener<AcknowledgedResponse>(consumer, o -> new Row1(-1L)));
                return;
            }
            ExecutionPlan executionPlan = DeletePlanner.deleteByQuery(this.table, plannerContext, where);
            NodeOperationTree nodeOpTree = NodeOperationTreeGenerator.fromPlan(executionPlan, executor.localNodeId());
            executor.phasesTaskFactory().create(plannerContext.jobId(), Collections.singletonList(nodeOpTree)).execute(consumer, plannerContext.transactionContext());
        }

        @Override
        public List<CompletableFuture<Long>> executeBulk(DependencyCarrier executor, PlannerContext plannerContext, List<Row> bulkParams, SubQueryResults subQueryResults) {
            ArrayList<NodeOperationTree> nodeOperationTreeList = new ArrayList<NodeOperationTree>(bulkParams.size());
            for (Row params : bulkParams) {
                WhereClause where = this.detailedQuery.toBoundWhereClause((DocTableInfo)this.table.tableInfo(), params, subQueryResults, plannerContext.transactionContext(), executor.nodeContext());
                ExecutionPlan executionPlan = DeletePlanner.deleteByQuery(this.table, plannerContext, where);
                nodeOperationTreeList.add(NodeOperationTreeGenerator.fromPlan(executionPlan, executor.localNodeId()));
            }
            return executor.phasesTaskFactory().create(plannerContext.jobId(), nodeOperationTreeList).executeBulk(plannerContext.transactionContext());
        }
    }
}

