/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.statement;

import io.crate.analyze.AnalyzedCopyTo;
import io.crate.analyze.BoundCopyTo;
import io.crate.analyze.CopyStatementSettings;
import io.crate.analyze.GenericPropertiesConverter;
import io.crate.analyze.PartitionPropertiesAnalyzer;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.exceptions.PartitionUnknownException;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.execution.dsl.phases.NodeOperationTree;
import io.crate.execution.dsl.projection.MergeCountProjection;
import io.crate.execution.dsl.projection.WriterProjection;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.execution.engine.NodeOperationTreeGenerator;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.RefVisitor;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.DocReferences;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.Collect;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.SubQueryResults;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Match;
import io.crate.planner.optimizer.rule.RewriteCollectToGet;
import io.crate.sql.tree.Assignment;
import io.crate.statistics.TableStats;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.settings.Settings;

public final class CopyToPlan
implements Plan {
    private final AnalyzedCopyTo copyTo;
    private final TableStats tableStats;

    public CopyToPlan(AnalyzedCopyTo copyTo, TableStats tableStats) {
        this.copyTo = copyTo;
        this.tableStats = tableStats;
    }

    @VisibleForTesting
    AnalyzedCopyTo copyTo() {
        return this.copyTo;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.COPY;
    }

    @Override
    public void executeOrFail(DependencyCarrier executor, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        ExecutionPlan executionPlan = CopyToPlan.planCopyToExecution(this.copyTo, plannerContext, this.tableStats, executor.projectionBuilder(), params, subQueryResults);
        NodeOperationTree nodeOpTree = NodeOperationTreeGenerator.fromPlan(executionPlan, executor.localNodeId());
        executor.phasesTaskFactory().create(plannerContext.jobId(), List.of(nodeOpTree)).execute(consumer, plannerContext.transactionContext());
    }

    @VisibleForTesting
    static ExecutionPlan planCopyToExecution(AnalyzedCopyTo copyTo, PlannerContext context, TableStats tableStats, ProjectionBuilder projectionBuilder, Row params, SubQueryResults subQueryResults) {
        BoundCopyTo boundedCopyTo = CopyToPlan.bind(copyTo, context.transactionContext(), context.nodeContext(), params, subQueryResults);
        WriterProjection.OutputFormat outputFormat = boundedCopyTo.outputFormat();
        if (outputFormat == null) {
            outputFormat = boundedCopyTo.columnsDefined() ? WriterProjection.OutputFormat.JSON_ARRAY : WriterProjection.OutputFormat.JSON_OBJECT;
        }
        WriterProjection projection = ProjectionBuilder.writerProjection(boundedCopyTo.outputs(), boundedCopyTo.uri(), boundedCopyTo.compressionType(), boundedCopyTo.overwrites(), boundedCopyTo.outputNames(), outputFormat);
        Collect collect = Collect.create(new DocTableRelation(boundedCopyTo.table()), boundedCopyTo.outputs(), boundedCopyTo.whereClause(), Set.of(), tableStats, context.params());
        LogicalPlan source = CopyToPlan.optimizeCollect(context, tableStats, collect);
        ExecutionPlan executionPlan = source.build(context, projectionBuilder, 0, 0, null, null, params, SubQueryResults.EMPTY);
        executionPlan.addProjection(projection);
        return Merge.ensureOnHandler(executionPlan, context, List.of(MergeCountProjection.INSTANCE));
    }

    private static LogicalPlan optimizeCollect(PlannerContext context, TableStats tableStats, LogicalPlan collect) {
        RewriteCollectToGet rewriteCollectToGet = new RewriteCollectToGet();
        Match<Collect> match = rewriteCollectToGet.pattern().accept(collect, Captures.empty());
        if (match.isPresent()) {
            LogicalPlan plan = rewriteCollectToGet.apply(match.value(), match.captures(), tableStats, (TransactionContext)context.transactionContext(), context.nodeContext());
            return plan == null ? collect : plan;
        }
        return collect;
    }

    @VisibleForTesting
    public static BoundCopyTo bind(AnalyzedCopyTo copyTo, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, parameters, subQueryResults);
        DocTableInfo table = (DocTableInfo)copyTo.tableInfo();
        List<String> partitions = CopyToPlan.resolvePartitions(Lists2.map(copyTo.table().partitionProperties(), x -> x.map(eval)), table);
        List<Object> outputs = new ArrayList();
        HashMap<ColumnIdent, Symbol> overwrites = null;
        boolean columnsDefined = false;
        ArrayList<String> outputNames = new ArrayList<String>(copyTo.columns().size());
        if (!copyTo.columns().isEmpty()) {
            for (Symbol symbol : copyTo.columns()) {
                assert (symbol instanceof Reference) : "Only references are expected here";
                RefVisitor.visitRefs(symbol, r -> outputNames.add(r.column().sqlFqn()));
                outputs.add(DocReferences.toSourceLookup(symbol));
            }
            columnsDefined = true;
        } else {
            Reference sourceRef;
            if (table.isPartitioned() && partitions.isEmpty()) {
                overwrites = new HashMap<ColumnIdent, Symbol>();
                for (Reference reference : table.partitionedByColumns()) {
                    if (reference instanceof GeneratedReference) continue;
                    overwrites.put(reference.column(), reference);
                }
                sourceRef = overwrites.size() > 0 ? table.getReference(DocSysColumns.DOC) : table.getReference(DocSysColumns.RAW);
            } else {
                sourceRef = table.getReference(DocSysColumns.RAW);
            }
            outputs = List.of(sourceRef);
        }
        Settings settings = GenericPropertiesConverter.genericPropertiesToSettings(copyTo.properties().map(eval), CopyStatementSettings.OUTPUT_SETTINGS);
        WriterProjection.CompressionType compressionType = CopyStatementSettings.settingAsEnum(WriterProjection.CompressionType.class, CopyStatementSettings.COMPRESSION_SETTING.get(settings));
        WriterProjection.OutputFormat outputFormat = CopyStatementSettings.settingAsEnum(WriterProjection.OutputFormat.class, CopyStatementSettings.OUTPUT_FORMAT_SETTING.get(settings));
        if (!columnsDefined && outputFormat == WriterProjection.OutputFormat.JSON_ARRAY) {
            throw new UnsupportedFeatureException("Output format not supported without specifying columns.");
        }
        WhereClause whereClause = new WhereClause(copyTo.whereClause(), partitions, Collections.emptySet());
        return new BoundCopyTo(outputs, table, whereClause, Literal.of(DataTypes.STRING.sanitizeValue(eval.apply(copyTo.uri()))), compressionType, outputFormat, outputNames.isEmpty() ? null : outputNames, columnsDefined, overwrites);
    }

    private static List<String> resolvePartitions(List<Assignment<Object>> partitionProperties, DocTableInfo table) {
        if (partitionProperties.isEmpty()) {
            return Collections.emptyList();
        }
        PartitionName partitionName = PartitionPropertiesAnalyzer.toPartitionName(table, partitionProperties);
        if (!table.partitions().contains(partitionName)) {
            throw new PartitionUnknownException(partitionName);
        }
        return List.of(partitionName.asIndexName());
    }
}

