/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.statement;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import io.crate.analyze.AnalyzedCopyFrom;
import io.crate.analyze.AnalyzedCopyFromReturnSummary;
import io.crate.analyze.BoundCopyFrom;
import io.crate.analyze.CopyFromParserProperties;
import io.crate.analyze.CopyStatementSettings;
import io.crate.analyze.GenericPropertiesConverter;
import io.crate.analyze.PartitionPropertiesAnalyzer;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.copy.NodeFilters;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.dsl.phases.FileUriCollectPhase;
import io.crate.execution.dsl.phases.NodeOperationTree;
import io.crate.execution.dsl.projection.AbstractIndexWriterProjection;
import io.crate.execution.dsl.projection.MergeCountProjection;
import io.crate.execution.dsl.projection.SourceIndexWriterProjection;
import io.crate.execution.dsl.projection.SourceIndexWriterReturnSummaryProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.engine.NodeOperationTreeGenerator;
import io.crate.expression.reference.file.SourceLineNumberExpression;
import io.crate.expression.reference.file.SourceUriExpression;
import io.crate.expression.reference.file.SourceUriFailureExpression;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.node.dql.Collect;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.GenericProperties;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.Settings;

public final class CopyFromPlan
implements Plan {
    private final AnalyzedCopyFrom copyFrom;

    public CopyFromPlan(AnalyzedCopyFrom copyFrom) {
        this.copyFrom = copyFrom;
    }

    public AnalyzedCopyFrom copyFrom() {
        return this.copyFrom;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.COPY;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        ExecutionPlan plan = CopyFromPlan.planCopyFromExecution(this.copyFrom, dependencies.clusterService().state().nodes(), plannerContext, params, subQueryResults);
        NodeOperationTree nodeOpTree = NodeOperationTreeGenerator.fromPlan(plan, dependencies.localNodeId());
        dependencies.phasesTaskFactory().create(plannerContext.jobId(), List.of(nodeOpTree)).execute(consumer, plannerContext.transactionContext());
    }

    @VisibleForTesting
    public static BoundCopyFrom bind(AnalyzedCopyFrom copyFrom, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, parameters, subQueryResults);
        String partitionIdent = !copyFrom.table().partitionProperties().isEmpty() ? PartitionPropertiesAnalyzer.toPartitionName(copyFrom.tableInfo(), Lists2.map(copyFrom.table().partitionProperties(), x -> x.map(eval))).ident() : null;
        GenericProperties<Object> properties = copyFrom.properties().map(eval);
        Predicate<DiscoveryNode> nodeFiltersPredicate = CopyFromPlan.discoveryNodePredicate(properties.properties().getOrDefault("node_filters", null));
        Settings settings = GenericPropertiesConverter.genericPropertiesToSettings(properties);
        FileUriCollectPhase.InputFormat inputFormat = CopyStatementSettings.settingAsEnum(FileUriCollectPhase.InputFormat.class, settings.get(CopyStatementSettings.INPUT_FORMAT_SETTING.getKey(), CopyStatementSettings.INPUT_FORMAT_SETTING.getDefault(Settings.EMPTY)));
        Symbol boundedURI = CopyFromPlan.validateAndConvertToLiteral(eval.apply(copyFrom.uri()));
        return new BoundCopyFrom(copyFrom.tableInfo(), partitionIdent, settings, boundedURI, inputFormat, nodeFiltersPredicate);
    }

    public static ExecutionPlan planCopyFromExecution(AnalyzedCopyFrom copyFrom, DiscoveryNodes allNodes, PlannerContext context, Row params, SubQueryResults subQueryResults) {
        SourceIndexWriterProjection sourceIndexWriterProjection;
        ColumnIdent clusteredBy;
        BoundCopyFrom boundedCopyFrom = CopyFromPlan.bind(copyFrom, context.transactionContext(), context.nodeContext(), params, subQueryResults);
        DocTableInfo table = boundedCopyFrom.tableInfo();
        String partitionIdent = boundedCopyFrom.partitionIdent();
        List<Object> partitionedByNames = Collections.emptyList();
        List<String> partitionValues = Collections.emptyList();
        if (partitionIdent == null) {
            if (table.isPartitioned()) {
                partitionedByNames = Lists2.map(table.partitionedBy(), ColumnIdent::fqn);
            }
        } else {
            assert (table.isPartitioned()) : "table must be partitioned if partitionIdent is set";
            partitionValues = PartitionName.decodeIdent(partitionIdent);
        }
        if (DocSysColumns.ID.equals(clusteredBy = table.clusteredBy())) {
            clusteredBy = null;
        }
        List<Reference> primaryKeyRefs = table.primaryKey().stream().filter(r -> !r.equals(DocSysColumns.ID)).map(table::getReference).collect(Collectors.toList());
        List<Symbol> toCollect = CopyFromPlan.getSymbolsRequiredForShardIdCalc(primaryKeyRefs, table.partitionedByColumns(), clusteredBy == null ? null : table.getReference(clusteredBy));
        Reference rawOrDoc = CopyFromPlan.rawOrDoc(table, partitionIdent);
        int rawOrDocIdx = toCollect.size();
        toCollect.add(rawOrDoc);
        String[] excludes = partitionedByNames.size() > 0 ? partitionedByNames.toArray(new String[0]) : null;
        InputColumns.SourceSymbols sourceSymbols = new InputColumns.SourceSymbols(toCollect);
        Symbol clusteredByInputCol = null;
        if (clusteredBy != null) {
            clusteredByInputCol = InputColumns.create((Symbol)table.getReference(clusteredBy), sourceSymbols);
        }
        List<? extends Symbol> projectionOutputs = AbstractIndexWriterProjection.OUTPUTS;
        boolean returnSummary = copyFrom instanceof AnalyzedCopyFromReturnSummary;
        if (returnSummary) {
            InputColumn sourceUriSymbol = new InputColumn(toCollect.size(), DataTypes.STRING);
            toCollect.add(SourceUriExpression.getReferenceForRelation(table.ident()));
            InputColumn sourceUriFailureSymbol = new InputColumn(toCollect.size(), DataTypes.STRING);
            toCollect.add(SourceUriFailureExpression.getReferenceForRelation(table.ident()));
            InputColumn lineNumberSymbol = new InputColumn(toCollect.size(), DataTypes.LONG);
            toCollect.add(SourceLineNumberExpression.getReferenceForRelation(table.ident()));
            List<Symbol> fields = ((AnalyzedCopyFromReturnSummary)copyFrom).outputs();
            projectionOutputs = InputColumns.create(fields, new InputColumns.SourceSymbols(fields));
            sourceIndexWriterProjection = new SourceIndexWriterReturnSummaryProjection(table.ident(), partitionIdent, table.getReference(DocSysColumns.RAW), new InputColumn(rawOrDocIdx, rawOrDoc.valueType()), table.primaryKey(), InputColumns.create(table.partitionedByColumns(), sourceSymbols), clusteredBy, boundedCopyFrom.settings(), null, excludes, InputColumns.create(primaryKeyRefs, sourceSymbols), clusteredByInputCol, projectionOutputs, table.isPartitioned(), sourceUriSymbol, sourceUriFailureSymbol, lineNumberSymbol);
        } else {
            sourceIndexWriterProjection = new SourceIndexWriterProjection(table.ident(), partitionIdent, table.getReference(DocSysColumns.RAW), new InputColumn(rawOrDocIdx, rawOrDoc.valueType()), table.primaryKey(), InputColumns.create(table.partitionedByColumns(), sourceSymbols), clusteredBy, boundedCopyFrom.settings(), null, excludes, InputColumns.create(primaryKeyRefs, sourceSymbols), clusteredByInputCol, projectionOutputs, table.isPartitioned());
        }
        if (partitionValues != null) {
            CopyFromPlan.rewriteToCollectToUsePartitionValues(table.partitionedByColumns(), partitionValues, toCollect);
        }
        FileUriCollectPhase collectPhase = new FileUriCollectPhase(context.jobId(), context.nextExecutionPhaseId(), "copyFrom", CopyFromPlan.getExecutionNodes(allNodes, boundedCopyFrom.settings().getAsInt("num_readers", allNodes.getSize()), boundedCopyFrom.nodePredicate()), boundedCopyFrom.uri(), toCollect, Collections.emptyList(), boundedCopyFrom.settings().get("compression", null), boundedCopyFrom.settings().getAsBoolean("shared", null), CopyFromParserProperties.of(boundedCopyFrom.settings()), boundedCopyFrom.inputFormat());
        Collect collect = new Collect(collectPhase, -1, 0, 1, -1, null);
        collect.addProjection(sourceIndexWriterProjection);
        List<Object> handlerProjections = returnSummary ? Collections.emptyList() : List.of(MergeCountProjection.INSTANCE);
        return Merge.ensureOnHandler(collect, context, handlerProjections);
    }

    private static void rewriteToCollectToUsePartitionValues(List<Reference> partitionedByColumns, List<String> partitionValues, List<Symbol> toCollect) {
        for (int i = 0; i < partitionValues.size(); ++i) {
            Reference partitionedByColumn = partitionedByColumns.get(i);
            int idx = partitionedByColumn instanceof GeneratedReference ? toCollect.indexOf(((GeneratedReference)partitionedByColumn).generatedExpression()) : toCollect.indexOf(partitionedByColumn);
            if (idx <= -1) continue;
            toCollect.set(idx, Literal.of(partitionValues.get(i)));
        }
    }

    private static List<Symbol> getSymbolsRequiredForShardIdCalc(List<Reference> primaryKeyRefs, List<Reference> partitionedByRefs, @Nullable Reference clusteredBy) {
        HashSet<Symbol> toCollectUnique = new HashSet<Symbol>();
        primaryKeyRefs.forEach(r -> CopyFromPlan.addWithRefDependencies(toCollectUnique, r));
        partitionedByRefs.forEach(r -> CopyFromPlan.addWithRefDependencies(toCollectUnique, r));
        if (clusteredBy != null) {
            CopyFromPlan.addWithRefDependencies(toCollectUnique, clusteredBy);
        }
        return new ArrayList<Symbol>(toCollectUnique);
    }

    private static void addWithRefDependencies(HashSet<Symbol> toCollectUnique, Reference ref) {
        if (ref instanceof GeneratedReference) {
            toCollectUnique.add(((GeneratedReference)ref).generatedExpression());
        } else {
            toCollectUnique.add(ref);
        }
    }

    private static Reference rawOrDoc(DocTableInfo table, String selectedPartitionIdent) {
        if (table.isPartitioned() && selectedPartitionIdent == null) {
            return table.getReference(DocSysColumns.DOC);
        }
        return table.getReference(DocSysColumns.RAW);
    }

    private static Collection<String> getExecutionNodes(DiscoveryNodes allNodes, int maxNodes, Predicate<DiscoveryNode> nodeFilters) {
        int counter = maxNodes;
        ArrayList<String> nodes = new ArrayList<String>(allNodes.getSize());
        for (ObjectCursor cursor : allNodes.getDataNodes().values()) {
            if (!nodeFilters.test((DiscoveryNode)cursor.value) || counter-- <= 0) continue;
            nodes.add(((DiscoveryNode)cursor.value).getId());
        }
        return nodes;
    }

    private static Symbol validateAndConvertToLiteral(Object uri) {
        if (uri instanceof String) {
            return Literal.of(DataTypes.STRING.sanitizeValue(uri));
        }
        if (uri instanceof List) {
            Object value = ((List)uri).get(0);
            if (!(value instanceof String)) {
                throw AnalyzedCopyFrom.raiseInvalidType(DataTypes.guessType(uri));
            }
            return Literal.of(DataTypes.STRING_ARRAY, DataTypes.STRING_ARRAY.sanitizeValue(uri));
        }
        throw AnalyzedCopyFrom.raiseInvalidType(DataTypes.guessType(uri));
    }

    private static Predicate<DiscoveryNode> discoveryNodePredicate(@Nullable Object nodeFilter) {
        if (nodeFilter == null) {
            return discoveryNode -> true;
        }
        try {
            return NodeFilters.fromMap((Map)nodeFilter);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid parameter passed to %s. Expected an object with name or id keys and string values. Got '%s'", "node_filters", nodeFilter));
        }
    }
}

