/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.selectivity;

import io.crate.data.Row;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.ParameterSymbol;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.statistics.ColumnStats;
import io.crate.statistics.MostCommonValues;
import io.crate.statistics.Stats;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class SelectivityFunctions {
    private static final double DEFAULT_EQ_SEL = 0.005;
    private static final double MAGIC_SEL = 0.333;

    public static long estimateNumRows(Stats stats, Symbol query, @Nullable Row params) {
        SelectivityEstimator estimator = new SelectivityEstimator(stats, params);
        return (long)((double)stats.numDocs() * query.accept(estimator, null));
    }

    private static double isNullSelectivity(Symbol arg, Stats stats) {
        ColumnIdent column = SelectivityFunctions.getColumn(arg);
        if (column == null) {
            return 0.333;
        }
        ColumnStats columnStats = stats.statsByColumn().get(column);
        if (columnStats == null) {
            return 0.333;
        }
        return columnStats.nullFraction();
    }

    private static double eqSelectivity(Symbol leftArg, Symbol rightArg, Stats stats, @Nullable Row params) {
        ColumnIdent column = SelectivityFunctions.getColumn(leftArg);
        if (column == null) {
            return 0.005;
        }
        ColumnStats columnStats = stats.statsByColumn().get(column);
        if (columnStats == null) {
            return 0.005;
        }
        if (rightArg instanceof ParameterSymbol && params != null) {
            Object value = params.get(((ParameterSymbol)rightArg).index());
            return SelectivityFunctions.eqSelectivityFromValueAndStats(value, columnStats);
        }
        if (rightArg instanceof Literal) {
            return SelectivityFunctions.eqSelectivityFromValueAndStats(((Literal)rightArg).value(), columnStats);
        }
        return 1.0 / columnStats.approxDistinct();
    }

    private static double eqSelectivityFromValueAndStats(Object value, ColumnStats columnStats) {
        if (value == null) {
            return 0.0;
        }
        MostCommonValues mcv = columnStats.mostCommonValues();
        int idx = Arrays.asList(mcv.values()).indexOf(value);
        if (idx < 0) {
            return 1.0 / columnStats.approxDistinct();
        }
        return mcv.frequencies()[idx];
    }

    @Nullable
    private static ColumnIdent getColumn(Symbol symbol) {
        if (symbol instanceof Reference) {
            return ((Reference)symbol).column();
        }
        if (symbol instanceof ScopedSymbol) {
            return ((ScopedSymbol)symbol).column();
        }
        return null;
    }

    static class SelectivityEstimator
    extends SymbolVisitor<Void, Double> {
        private final Stats stats;
        @Nullable
        private final Row params;

        SelectivityEstimator(Stats stats, @Nullable Row params) {
            this.stats = stats;
            this.params = params;
        }

        @Override
        protected Double visitSymbol(Symbol symbol, Void context) {
            return 1.0;
        }

        @Override
        public Double visitLiteral(Literal literal, Void context) {
            Object value = literal.value();
            if (value instanceof Boolean) {
                Boolean val = (Boolean)value;
                return val == false ? 0.0 : 1.0;
            }
            if (value == null) {
                return 0.0;
            }
            return (Double)super.visitLiteral(literal, context);
        }

        @Override
        public Double visitFunction(Function function, Void context) {
            switch (function.name()) {
                case "op_and": {
                    double selectivity = 1.0;
                    for (Symbol argument : function.arguments()) {
                        selectivity *= argument.accept(this, context).doubleValue();
                    }
                    return selectivity;
                }
                case "op_or": {
                    double sel1 = 1.0;
                    for (Symbol argument : function.arguments()) {
                        double sel2 = argument.accept(this, context);
                        sel1 = sel1 + sel2 - sel1 * sel2;
                    }
                    return sel1;
                }
                case "op_=": {
                    List<Symbol> arguments = function.arguments();
                    return SelectivityFunctions.eqSelectivity(arguments.get(0), arguments.get(1), this.stats, this.params);
                }
                case "op_not": {
                    return 1.0 - function.arguments().get(0).accept(this, context);
                }
                case "op_isnull": {
                    List<Symbol> arguments = function.arguments();
                    return SelectivityFunctions.isNullSelectivity(arguments.get(0), this.stats);
                }
            }
            return 0.333;
        }
    }
}

