/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.symbol.rule;

import io.crate.expression.operator.any.AnyOperators;
import io.crate.expression.scalar.cast.CastFunctionResolver;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.metadata.NodeContext;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.symbol.FunctionSymbolResolver;
import io.crate.planner.optimizer.symbol.Rule;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import java.util.List;
import java.util.Optional;

public class MoveReferenceCastToLiteralCastOnAnyOperatorsWhenRightIsReference
implements Rule<Function> {
    private final Capture<Function> castCapture;
    private final Pattern<Function> pattern;
    private final FunctionSymbolResolver functionResolver;

    public MoveReferenceCastToLiteralCastOnAnyOperatorsWhenRightIsReference(FunctionSymbolResolver functionResolver) {
        this.functionResolver = functionResolver;
        this.castCapture = new Capture();
        this.pattern = Pattern.typeOf(Function.class).with(f -> AnyOperators.OPERATOR_NAMES.contains(f.name())).with(f -> f.arguments().get(0).symbolType() == SymbolType.LITERAL).with(f -> Optional.of(f.arguments().get(1)), Pattern.typeOf(Function.class).capturedAs(this.castCapture).with(f -> CastFunctionResolver.CAST_FUNCTION_NAMES.contains(f.name())).with(f -> f.arguments().get(0).symbolType() == SymbolType.REFERENCE));
    }

    @Override
    public Pattern<Function> pattern() {
        return this.pattern;
    }

    @Override
    public Symbol apply(Function operator, Captures captures, NodeContext nodeCtx) {
        Symbol literal = operator.arguments().get(0);
        Function castFunction = captures.get(this.castCapture);
        Symbol reference = castFunction.arguments().get(0);
        DataType<Object> targetType = reference.valueType();
        if (targetType.id() != 100) {
            return null;
        }
        targetType = ((ArrayType)targetType).innerType();
        String operatorName = operator.name();
        if (!List.of(AnyOperators.Type.EQ.opName(), AnyOperators.Type.NEQ.opName()).contains(operatorName) && literal.valueType().id() == 100) {
            return null;
        }
        return this.functionResolver.apply(operator.name(), List.of(literal.cast(targetType, new CastMode[0]), reference));
    }
}

