/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.symbol;

import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.common.collections.Lists2;
import io.crate.exceptions.ConversionException;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.FunctionCopyVisitor;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.planner.PlannerContext;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Match;
import io.crate.planner.optimizer.symbol.FunctionSymbolResolver;
import io.crate.planner.optimizer.symbol.Rule;
import io.crate.planner.optimizer.symbol.rule.MoveArrayLengthOnReferenceCastToLiteralCastInsideOperators;
import io.crate.planner.optimizer.symbol.rule.MoveReferenceCastToLiteralCastInsideOperators;
import io.crate.planner.optimizer.symbol.rule.MoveReferenceCastToLiteralCastOnAnyOperatorsWhenLeftIsReference;
import io.crate.planner.optimizer.symbol.rule.MoveReferenceCastToLiteralCastOnAnyOperatorsWhenRightIsReference;
import io.crate.planner.optimizer.symbol.rule.MoveSubscriptOnReferenceCastToLiteralCastInsideOperators;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;

public class Optimizer {
    private static final Logger LOGGER = LogManager.getLogger(Optimizer.class);
    private final List<Rule<?>> rules;
    private final Supplier<Version> minNodeVersionInCluster;
    private final NodeContext nodeCtx;
    private final Visitor visitor = new Visitor();

    public static Symbol optimizeCasts(Symbol query, PlannerContext plannerContext) {
        Optimizer optimizer = new Optimizer(plannerContext.transactionContext(), plannerContext.nodeContext(), () -> plannerContext.clusterState().nodes().getMinNodeVersion(), List.of(MoveReferenceCastToLiteralCastInsideOperators::new, MoveReferenceCastToLiteralCastOnAnyOperatorsWhenRightIsReference::new, MoveReferenceCastToLiteralCastOnAnyOperatorsWhenLeftIsReference::new, MoveSubscriptOnReferenceCastToLiteralCastInsideOperators::new, MoveArrayLengthOnReferenceCastToLiteralCastInsideOperators::new));
        return optimizer.optimize(query);
    }

    public Optimizer(CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx, Supplier<Version> minNodeVersionInCluster, List<java.util.function.Function<FunctionSymbolResolver, Rule<?>>> rules) {
        FunctionSymbolResolver functionResolver = (f, args) -> {
            try {
                return ExpressionAnalyzer.allocateFunction(f, args, null, null, coordinatorTxnCtx, nodeCtx);
            }
            catch (ConversionException e) {
                return null;
            }
        };
        this.rules = Lists2.map(rules, r -> (Rule)r.apply(functionResolver));
        this.minNodeVersionInCluster = minNodeVersionInCluster;
        this.nodeCtx = nodeCtx;
    }

    public Symbol optimize(Symbol node) {
        return node.accept(this.visitor, null);
    }

    public Symbol tryApplyRules(Symbol node) {
        int numIterations;
        boolean isTraceEnabled = LOGGER.isTraceEnabled();
        boolean done = false;
        for (numIterations = 0; !done && numIterations < 10000; ++numIterations) {
            done = true;
            Version minVersion = this.minNodeVersionInCluster.get();
            for (Rule<?> rule : this.rules) {
                Symbol transformedNode;
                Match<?> match;
                if (minVersion.before(rule.requiredVersion()) || !(match = rule.pattern().accept(node, Captures.empty())).isPresent()) continue;
                if (isTraceEnabled) {
                    LOGGER.trace("Rule '" + rule.getClass().getSimpleName() + "' matched");
                }
                if ((transformedNode = rule.apply(match.value(), match.captures(), this.nodeCtx)) == null) continue;
                if (isTraceEnabled) {
                    LOGGER.trace("Rule '" + rule.getClass().getSimpleName() + "' transformed the symbol");
                }
                node = transformedNode;
                done = false;
            }
        }
        assert (numIterations < 10000) : "Optimizer reached 10_000 iterations safety guard. This is an indication of a broken rule that matches again and again";
        return node;
    }

    private class Visitor
    extends FunctionCopyVisitor<Void> {
        private Visitor() {
        }

        @Override
        public Symbol visitFunction(Function symbol, Void context) {
            Symbol maybeTransformedSymbol = Optimizer.this.tryApplyRules(symbol);
            if (!symbol.equals(maybeTransformedSymbol)) {
                return maybeTransformedSymbol;
            }
            return super.visitFunction(symbol, context);
        }
    }
}

