/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.planner.node.fetch.FetchSource;
import io.crate.planner.operators.Collect;
import io.crate.planner.operators.Eval;
import io.crate.planner.operators.Fetch;
import io.crate.planner.operators.FetchRewrite;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.Limit;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.Order;
import io.crate.planner.operators.Rename;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Match;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.statistics.TableStats;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RewriteToQueryThenFetch
implements Rule<Limit> {
    private static final Pattern<Order> ORDER_COLLECT = Pattern.typeOf(Order.class).with(Patterns.source(), Pattern.typeOf(Collect.class));
    private static final Pattern<Rename> RENAME_ORDER_COLLECT = Pattern.typeOf(Rename.class).with(Patterns.source(), Pattern.typeOf(Order.class).with(Patterns.source(), Pattern.typeOf(Collect.class)));
    private final Pattern<Limit> pattern = Pattern.typeOf(Limit.class);

    @Override
    public Pattern<Limit> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Limit limit, Captures captures, TableStats tableStats, TransactionContext txnCtx, NodeContext nodeCtx) {
        if (Symbols.containsColumn(limit.outputs(), DocSysColumns.FETCHID)) {
            return null;
        }
        FetchRewrite fetchRewrite = limit.source().rewriteToFetch(tableStats, Set.of());
        if (fetchRewrite == null) {
            return null;
        }
        List<Reference> fetchRefs = fetchRewrite.extractFetchRefs();
        Map<RelationName, FetchSource> fetchSourceByRelation = fetchRewrite.createFetchSources();
        return new Fetch(fetchRewrite.replacedOutputs(), fetchRefs, fetchSourceByRelation, limit.replaceSources(List.of(fetchRewrite.newPlan())));
    }

    public static LogicalPlan tryRewrite(AnalyzedRelation relation, LogicalPlan plan, TableStats tableStats) {
        Match<ForwardingLogicalPlan> match = ORDER_COLLECT.accept(plan, Captures.empty());
        if (match.isPresent()) {
            return RewriteToQueryThenFetch.doRewrite(relation, plan, tableStats);
        }
        match = RENAME_ORDER_COLLECT.accept(plan, Captures.empty());
        if (match.isPresent()) {
            return RewriteToQueryThenFetch.doRewrite(relation, plan, tableStats);
        }
        return plan;
    }

    private static LogicalPlan doRewrite(AnalyzedRelation relation, LogicalPlan plan, TableStats tableStats) {
        FetchRewrite fetchRewrite = plan.rewriteToFetch(tableStats, List.of());
        if (fetchRewrite == null) {
            return plan;
        }
        List<Reference> fetchRefs = fetchRewrite.extractFetchRefs();
        Map<RelationName, FetchSource> fetchSourceByRelation = fetchRewrite.createFetchSources();
        Fetch fetch = new Fetch(fetchRewrite.replacedOutputs(), fetchRefs, fetchSourceByRelation, fetchRewrite.newPlan());
        return Eval.create(fetch, relation.outputs());
    }
}

