/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.QuerySplitter;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.FieldReplacer;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.RefReplacer;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.TransactionContext;
import io.crate.planner.node.dql.join.JoinType;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.NestedLoopJoin;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.planner.optimizer.rule.FilterOnJoinsUtil;
import io.crate.statistics.TableStats;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class RewriteFilterOnOuterJoinToInnerJoin
implements Rule<Filter> {
    private final Capture<NestedLoopJoin> nlCapture = new Capture();
    private final Pattern<Filter> pattern = Pattern.typeOf(Filter.class).with(Patterns.source(), Pattern.typeOf(NestedLoopJoin.class).capturedAs(this.nlCapture).with(nl -> nl.joinType().isOuter() && !nl.isRewriteFilterOnOuterJoinToInnerJoinDone()));

    @Override
    public Pattern<Filter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Filter filter, Captures captures, TableStats tableStats, TransactionContext txnCtx, NodeContext nodeCtx) {
        boolean newJoinIsInnerJoin;
        LogicalPlan newRhs;
        LogicalPlan newLhs;
        EvaluatingNormalizer normalizer = EvaluatingNormalizer.functionOnlyNormalizer(nodeCtx);
        NestedLoopJoin nl = captures.get(this.nlCapture);
        Symbol query = filter.query();
        Map<Set<RelationName>, Symbol> splitQueries = QuerySplitter.split(query);
        if (splitQueries.size() == 1 && splitQueries.keySet().iterator().next().size() > 1) {
            return null;
        }
        LogicalPlan lhs = nl.sources().get(0);
        LogicalPlan rhs = nl.sources().get(1);
        Set<RelationName> leftName = lhs.getRelationNames();
        Set<RelationName> rightName = rhs.getRelationNames();
        Symbol leftQuery = splitQueries.remove(leftName);
        Symbol rightQuery = splitQueries.remove(rightName);
        switch (nl.joinType()) {
            case LEFT: {
                newLhs = FilterOnJoinsUtil.getNewSource(leftQuery, lhs);
                if (rightQuery == null) {
                    newRhs = rhs;
                    newJoinIsInnerJoin = false;
                    break;
                }
                if (RewriteFilterOnOuterJoinToInnerJoin.couldMatchOnNull(rightQuery, normalizer, txnCtx)) {
                    newRhs = rhs;
                    newJoinIsInnerJoin = false;
                    splitQueries.put(rightName, rightQuery);
                    break;
                }
                newRhs = FilterOnJoinsUtil.getNewSource(rightQuery, rhs);
                newJoinIsInnerJoin = true;
                break;
            }
            case RIGHT: {
                if (leftQuery == null) {
                    newLhs = lhs;
                    newJoinIsInnerJoin = false;
                } else if (RewriteFilterOnOuterJoinToInnerJoin.couldMatchOnNull(leftQuery, normalizer, txnCtx)) {
                    newLhs = lhs;
                    newJoinIsInnerJoin = false;
                    splitQueries.put(leftName, leftQuery);
                } else {
                    newLhs = FilterOnJoinsUtil.getNewSource(leftQuery, lhs);
                    newJoinIsInnerJoin = true;
                }
                newRhs = FilterOnJoinsUtil.getNewSource(rightQuery, rhs);
                break;
            }
            case FULL: {
                if (RewriteFilterOnOuterJoinToInnerJoin.couldMatchOnNull(leftQuery, normalizer, txnCtx)) {
                    newLhs = lhs;
                } else {
                    newLhs = FilterOnJoinsUtil.getNewSource(leftQuery, lhs);
                    if (leftQuery != null) {
                        splitQueries.put(leftName, leftQuery);
                    }
                }
                newRhs = RewriteFilterOnOuterJoinToInnerJoin.couldMatchOnNull(rightQuery, normalizer, txnCtx) ? rhs : FilterOnJoinsUtil.getNewSource(rightQuery, rhs);
                if (leftQuery != null) {
                    splitQueries.put(leftName, leftQuery);
                }
                if (rightQuery != null) {
                    splitQueries.put(rightName, rightQuery);
                }
                newJoinIsInnerJoin = newLhs != lhs && newRhs != rhs;
                break;
            }
            default: {
                throw new UnsupportedOperationException("The Rule to rewrite filter+outer-joins to inner joins must not be run on joins of type=" + nl.joinType());
            }
        }
        if (newLhs == lhs && newRhs == rhs) {
            return null;
        }
        NestedLoopJoin newJoin = new NestedLoopJoin(newLhs, newRhs, newJoinIsInnerJoin ? JoinType.INNER : nl.joinType(), nl.joinCondition(), nl.isFiltered(), nl.topMostLeftRelation(), nl.orderByWasPushedDown(), true);
        assert (newJoin.outputs().equals(nl.outputs())) : "Outputs after rewrite must be the same as before";
        return splitQueries.isEmpty() ? newJoin : new Filter(newJoin, AndOperator.join(splitQueries.values()));
    }

    private static boolean couldMatchOnNull(@Nullable Symbol query, EvaluatingNormalizer normalizer, TransactionContext txnCtx) {
        if (query == null) {
            return false;
        }
        return WhereClause.canMatch(normalizer.normalize(RefReplacer.replaceRefs(FieldReplacer.replaceFields(query, ignored -> Literal.NULL), ignored -> Literal.NULL), txnCtx));
    }
}

